//Falcon-180B DATASET v1.0 Category: Building a FTP Client ; Style: Claude Shannon
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#define PORT 21
#define BUFFER_SIZE 1024

void main() {
    int sockfd, newsockfd, portno;
    char buffer[BUFFER_SIZE];
    struct sockaddr_in serv_addr;
    struct sockaddr_in cli_addr;
    int addrlen;
    int opt = 1;

    fd_set readfds;

    char *username = "anonymous";
    char *password = "anonymous@example.com";

    sockfd = socket(AF_INET, SOCK_STREAM, 0);

    if (sockfd < 0) {
        printf("socket failed\n");
        exit(1);
    }

    setsockopt(sockfd, SOL_SOCKET, SO_REUSEADDR, &opt, sizeof(opt));

    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0) {
        printf("bind failed\n");
        exit(1);
    }

    listen(sockfd, 5);

    printf("FTP server listening on port %d\n", PORT);

    addrlen = sizeof(cli_addr);

    while (1) {
        FD_ZERO(&readfds);

        FD_SET(sockfd, &readfds);

        select(sockfd + 1, &readfds, NULL, NULL, NULL);

        newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, &addrlen);

        printf("Connection established with client: %s:%d\n", inet_ntoa(cli_addr.sin_addr), ntohs(cli_addr.sin_port));

        char *command;

        while (1) {
            bzero(buffer, BUFFER_SIZE);

            if (recv(newsockfd, buffer, BUFFER_SIZE, 0) <= 0) {
                printf("Client disconnected\n");
                close(newsockfd);
                break;
            }

            command = strtok(buffer, " ");

            if (strcmp(command, "USER") == 0) {
                send(newsockfd, "331 Password required for anonymous\n", strlen("331 Password required for anonymous\n"), 0);
            } else if (strcmp(command, "PASS") == 0) {
                send(newsockfd, "230 Login successful.\n", strlen("230 Login successful.\n"), 0);
            } else if (strcmp(command, "LIST") == 0) {
                send(newsockfd, "150 Opening ASCII mode data connection for /.\n", strlen("150 Opening ASCII mode data connection for /. \n"), 0);
                send(newsockfd, "226 Transfer complete.\n", strlen("226 Transfer complete.\n"), 0);
            } else if (strcmp(command, "RETR") == 0) {
                send(newsockfd, "150 Opening ASCII mode data connection for filename.\n", strlen("150 Opening ASCII mode data connection for filename.\n"), 0);
                send(newsockfd, "226 Transfer complete.\n", strlen("226 Transfer complete.\n"), 0);
            } else {
                send(newsockfd, "500 Unknown command.\n", strlen("500 Unknown command.\n"), 0);
            }
        }

        close(newsockfd);
    }
}