//Falcon-180B DATASET v1.0 Category: Memory Game ; Style: satisfied
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_ROWS 10
#define MAX_COLS 10

void generate_board(int board[MAX_ROWS][MAX_COLS]) {
    for (int i = 0; i < MAX_ROWS; i++) {
        for (int j = 0; j < MAX_COLS; j++) {
            board[i][j] = rand() % 2;
        }
    }
}

void print_board(int board[MAX_ROWS][MAX_COLS]) {
    for (int i = 0; i < MAX_ROWS; i++) {
        for (int j = 0; j < MAX_COLS; j++) {
            if (board[i][j] == 0) {
                printf(" ");
            } else {
                printf("X");
            }
        }
        printf("\n");
    }
}

void check_match(int board[MAX_ROWS][MAX_COLS], int row, int col) {
    int count = 0;
    int match_row = row;
    int match_col = col;

    while (match_row < MAX_ROWS && match_col < MAX_COLS && board[match_row][match_col] == board[row][col]) {
        count++;
        match_row++;
        match_col++;
    }

    if (count == 3) {
        printf("Match found!\n");
    } else {
        printf("No match found.\n");
    }
}

int main() {
    srand(time(NULL));

    int board[MAX_ROWS][MAX_COLS];
    generate_board(board);

    int player_row, player_col;
    printf("Player 1, enter your row and column: ");
    scanf("%d %d", &player_row, &player_col);

    int computer_row, computer_col;
    printf("Computer, enter your row and column: ");
    scanf("%d %d", &computer_row, &computer_col);

    while (1) {
        print_board(board);

        if (board[player_row][player_col] == 1) {
            check_match(board, player_row, player_col);
        } else if (board[computer_row][computer_col] == 1) {
            check_match(board, computer_row, computer_col);
        }

        if (board[player_row][player_col] == 1 && board[computer_row][computer_col] == 1) {
            printf("Tie game.\n");
            break;
        }
    }

    return 0;
}