//GPT-4o-mini DATASET v1.0 Category: Clustering Algorithm Implementation ; Style: ephemeral
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>

#define MAX_POINTS 100
#define MAX_CLUSTERS 10

typedef struct {
    double x;
    double y;
} Point;

typedef struct {
    Point centroid;
    Point points[MAX_POINTS];
    int point_count;
} Cluster;

double euclidean_distance(Point a, Point b) {
    return sqrt(pow(a.x - b.x, 2) + pow(a.y - b.y, 2));
}

void initialize_clusters(Cluster clusters[], int k, Point points[], int n) {
    for (int i = 0; i < k; i++) {
        clusters[i].centroid = points[rand() % n];
        clusters[i].point_count = 0;
    }
}

void assign_points_to_clusters(Cluster clusters[], int k, Point points[], int n) {
    for (int i = 0; i < n; i++) {
        double min_distance = __DBL_MAX__;
        int cluster_index = -1;

        for (int j = 0; j < k; j++) {
            double distance = euclidean_distance(points[i], clusters[j].centroid);
            if (distance < min_distance) {
                min_distance = distance;
                cluster_index = j;
            }
        }

        clusters[cluster_index].points[clusters[cluster_index].point_count++] = points[i];
    }
}

void update_centroids(Cluster clusters[], int k) {
    for (int i = 0; i < k; i++) {
        double sum_x = 0, sum_y = 0;
        for (int j = 0; j < clusters[i].point_count; j++) {
            sum_x += clusters[i].points[j].x;
            sum_y += clusters[i].points[j].y;
        }
        clusters[i].centroid.x = sum_x / clusters[i].point_count;
        clusters[i].centroid.y = sum_y / clusters[i].point_count;
    }
}

int clusters_changed(Cluster old_clusters[], Cluster new_clusters[], int k) {
    for (int i = 0; i < k; i++) {
        if (old_clusters[i].centroid.x != new_clusters[i].centroid.x || 
            old_clusters[i].centroid.y != new_clusters[i].centroid.y) {
            return 1;
        }
    }
    return 0;
}

void clear_clusters(Cluster clusters[], int k) {
    for (int i = 0; i < k; i++) {
        clusters[i].point_count = 0;
    }
}

void print_clusters(Cluster clusters[], int k) {
    for (int i = 0; i < k; i++) {
        printf("Cluster %d: Centroid: (%.2f, %.2f) Points:\n", i + 1, 
               clusters[i].centroid.x, clusters[i].centroid.y);
        for (int j = 0; j < clusters[i].point_count; j++) {
            printf("  (%.2f, %.2f)\n", clusters[i].points[j].x, clusters[i].points[j].y);
        }
        printf("\n");
    }
}

int main() {
    srand(time(NULL));
    int n, k;

    printf("Enter the number of points: ");
    scanf("%d", &n);
    printf("Enter the number of clusters: ");
    scanf("%d", &k);

    if (n > MAX_POINTS || k > MAX_CLUSTERS) {
        printf("Exceeded maximum limits. Exiting...\n");
        return 1;
    }

    Point points[MAX_POINTS];
    
    printf("Enter points (x, y):\n");
    for (int i = 0; i < n; i++) {
        scanf("%lf %lf", &points[i].x, &points[i].y);
    }

    Cluster clusters[MAX_CLUSTERS];
    initialize_clusters(clusters, k, points, n);

    int changed = 1;
    while (changed) {
        clear_clusters(clusters, k);
        assign_points_to_clusters(clusters, k, points, n);
        Cluster previous_clusters[MAX_CLUSTERS];
        for (int i = 0; i < k; i++) {
            previous_clusters[i] = clusters[i];
        }
        update_centroids(clusters, k);
        changed = clusters_changed(previous_clusters, clusters, k);
    }

    print_clusters(clusters, k);
    
    return 0;
}