//GPT-4o-mini DATASET v1.0 Category: Rogue-like Game with Procedural Generation ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <unistd.h>

#define MAP_WIDTH 10
#define MAP_HEIGHT 10
#define NUM_MONSTERS 3

typedef enum { EMPTY, PLAYER, MONSTER } Tile;

typedef struct {
    int x;
    int y;
} Position;

typedef struct {
    Position pos;
    int health;
} Player;

typedef struct {
    Position pos;
    int health;
} Monster;

Tile map[MAP_HEIGHT][MAP_WIDTH];
Player player;
Monster monsters[NUM_MONSTERS];

void initialize_map() {
    for (int y = 0; y < MAP_HEIGHT; y++) {
        for (int x = 0; x < MAP_WIDTH; x++) {
            map[y][x] = EMPTY;
        }
    }
}

void place_player() {
    player.pos.x = rand() % MAP_WIDTH;
    player.pos.y = rand() % MAP_HEIGHT;
    map[player.pos.y][player.pos.x] = PLAYER;
}

void place_monsters() {
    for (int i = 0; i < NUM_MONSTERS; i++) {
        monsters[i].pos.x = rand() % MAP_WIDTH;
        monsters[i].pos.y = rand() % MAP_HEIGHT;
        
        // Ensure no monster is placed on the player
        while (map[monsters[i].pos.y][monsters[i].pos.x] != EMPTY) {
            monsters[i].pos.x = rand() % MAP_WIDTH;
            monsters[i].pos.y = rand() % MAP_HEIGHT;
        }
        
        monsters[i].health = 10; // Each monster has 10 health
        map[monsters[i].pos.y][monsters[i].pos.x] = MONSTER;
    }
}

void print_map() {
    for (int y = 0; y < MAP_HEIGHT; y++) {
        for (int x = 0; x < MAP_WIDTH; x++) {
            switch (map[y][x]) {
                case EMPTY:
                    printf(". ");
                    break;
                case PLAYER:
                    printf("P ");
                    break;
                case MONSTER:
                    printf("M ");
                    break;
            }
        }
        printf("\n");
    }
}

void move_player(char direction) {
    int new_x = player.pos.x;
    int new_y = player.pos.y;

    switch (direction) {
        case 'w':
            new_y--;
            break;
        case 's':
            new_y++;
            break;
        case 'a':
            new_x--;
            break;
        case 'd':
            new_x++;
            break;
        default:
            printf("Invalid move! Use WASD to move.\n");
            return;
    }

    if (new_x < 0 || new_x >= MAP_WIDTH || new_y < 0 || new_y >= MAP_HEIGHT) {
        printf("Move out of bounds!\n");
        return;
    }

    if (map[new_y][new_x] == MONSTER) {
        printf("Encountered a monster! Combat begins!\n");
        // Simple combat
        while (monsters[0].health > 0 && player.health > 0) {
            monsters[0].health -= 5; // Player attacks
            printf("Monster health: %d\n", monsters[0].health);
            if (monsters[0].health > 0) {
                player.health -= 2; // Monster attacks
                printf("Player health: %d\n", player.health);
            }
        }
        if (player.health <= 0) {
            printf("You have been defeated!\n");
            exit(0);
        } else {
            printf("Monster defeated!\n");
            map[new_y][new_x] = EMPTY; // Remove monster from the map
        }
    }

    map[player.pos.y][player.pos.x] = EMPTY; // Clear old position
    player.pos.x = new_x;
    player.pos.y = new_y;
    map[player.pos.y][player.pos.x] = PLAYER; // New position
}

int main() {
    srand(time(NULL));
    player.health = 20;
    initialize_map();
    place_player();
    place_monsters();

    char command;
    while (player.health > 0) {
        print_map();
        printf("Your health: %d\n", player.health);
        printf("Enter move (w/a/s/d): ");
        scanf(" %c", &command);
        move_player(command);
    }

    printf("Game Over!\n");
    return 0;
}