//Falcon-180B DATASET v1.0 Category: Encryption ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define KEY_SIZE 16
#define BLOCK_SIZE 64

void encrypt(char* message, char* key) {
    int i, j, k;
    char cipher[strlen(message)];
    char key_expanded[KEY_SIZE];
    for (i = 0; i < KEY_SIZE; i++) {
        key_expanded[i] = key[i % strlen(key)];
    }
    int key_index = 0;
    for (i = 0; i < strlen(message); i += BLOCK_SIZE) {
        for (j = 0; j < BLOCK_SIZE && i + j < strlen(message); j++) {
            cipher[i + j] = message[i + j] ^ key_expanded[key_index];
            key_index = (key_index + 1) % KEY_SIZE;
        }
    }
    strcpy(message, cipher);
}

void decrypt(char* cipher, char* key) {
    int i, j, k;
    char message[strlen(cipher)];
    char key_expanded[KEY_SIZE];
    for (i = 0; i < KEY_SIZE; i++) {
        key_expanded[i] = key[i % strlen(key)];
    }
    int key_index = 0;
    for (i = 0; i < strlen(cipher); i += BLOCK_SIZE) {
        for (j = 0; j < BLOCK_SIZE && i + j < strlen(cipher); j++) {
            message[i + j] = cipher[i + j] ^ key_expanded[key_index];
            key_index = (key_index + 1) % KEY_SIZE;
        }
    }
    strcpy(cipher, message);
}

int main() {
    char message[100] = "Hello, world!";
    char key[16] = "secret_key1234";
    encrypt(message, key);
    printf("Encrypted message: %s\n", message);
    decrypt(message, key);
    printf("Decrypted message: %s\n", message);
    return 0;
}