//Falcon-180B DATASET v1.0 Category: Haunted House Simulator ; Style: all-encompassing
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define ROWS 10
#define COLS 20

char maze[ROWS][COLS];
int player_row, player_col;
int exit_row, exit_col;

void generate_maze() {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            maze[i][j] = rand() % 2? '.' : '#';
        }
    }
    exit_row = rand() % ROWS;
    exit_col = rand() % COLS;
    maze[exit_row][exit_col] = 'E';
}

void print_maze() {
    int i, j;
    for (i = 0; i < ROWS; i++) {
        for (j = 0; j < COLS; j++) {
            printf("%c", maze[i][j]);
        }
        printf("\n");
    }
}

int move(int dr, int dc) {
    int nr, nc;
    nr = player_row + dr;
    nc = player_col + dc;
    if (nr >= 0 && nr < ROWS && nc >= 0 && nc < COLS && maze[nr][nc]!= '#') {
        player_row = nr;
        player_col = nc;
        return 1;
    }
    return 0;
}

int main() {
    srand(time(0));
    generate_maze();
    player_row = 0;
    player_col = 0;
    while (1) {
        system("clear");
        print_maze();
        printf("You are at (%d, %d)\n", player_row, player_col);
        if (player_row == exit_row && player_col == exit_col) {
            printf("You have escaped the haunted house!\n");
            break;
        }
        char ch;
        scanf("%c", &ch);
        switch (ch) {
        case 'w':
        case 'W':
            move(0, -1);
            break;
        case's':
        case 'S':
            move(0, 1);
            break;
        case 'a':
        case 'A':
            move(-1, 0);
            break;
        case 'd':
        case 'D':
            move(1, 0);
            break;
        default:
            break;
        }
    }
    return 0;
}