//GPT-4o-mini DATASET v1.0 Category: Scientific Calculator Implementation ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define BUFFER_SIZE 100
#define PI 3.14159265358979323846

int get_input(double *result);
void calculate(double num1, double num2, char operation, double *result);
void display_menu();
void clear_buffer();

int main() {
    double num1, num2, result;
    char operation;
    int keep_running = 1;

    printf("Welcome to Donald Knuth's Scientific Calculator!\n");
    printf("Press Ctrl+C to exit anytime.\n");

    while (keep_running) {
        display_menu();

        if (get_input(&num1)) {
            printf("Enter an operator (+, -, *, /, ^, r for sqrt, p for sin, c for cos, t for tan): ");
            scanf(" %c", &operation);

            if (operation == 'r') {
                result = sqrt(num1);
                printf("Square root of %.2lf is: %.2lf\n", num1, result);
            } else if (operation == 'p') {
                result = sin(num1 * PI / 180);
                printf("Sine of %.2lf degrees is: %.2lf\n", num1, result);
            } else if (operation == 'c') {
                result = cos(num1 * PI / 180);
                printf("Cosine of %.2lf degrees is: %.2lf\n", num1, result);
            } else if (operation == 't') {
                result = tan(num1 * PI / 180);
                printf("Tangent of %.2lf degrees is: %.2lf\n", num1, result);
            } else {
                if (get_input(&num2)) {
                    calculate(num1, num2, operation, &result);
                    printf("%.2lf %c %.2lf = %.2lf\n", num1, operation, num2, result);
                } else {
                    printf("Invalid input for the second number!\n");
                }
            }
        } else {
            printf("Invalid input for the first number!\n");
        }

        printf("Would you like to perform another calculation? (1 for Yes, 0 for No): ");
        scanf("%d", &keep_running);
        clear_buffer();
    }

    printf("Thank you for using the calculator! Goodbye!\n");
    return 0;
}

int get_input(double *result) {
    char buffer[BUFFER_SIZE];
    if (fgets(buffer, BUFFER_SIZE, stdin) != NULL) {
        if (sscanf(buffer, "%lf", result) == 1) {
            return 1;
        }
    }
    return 0;
}

void calculate(double num1, double num2, char operation, double *result) {
    switch (operation) {
        case '+':
            *result = num1 + num2;
            break;
        case '-':
            *result = num1 - num2;
            break;
        case '*':
            *result = num1 * num2;
            break;
        case '/':
            if (num2 != 0) {
                *result = num1 / num2;
            } else {
                printf("Error: Division by zero!\n");
                *result = 0; // to avoid undefined behavior
            }
            break;
        case '^':
            *result = pow(num1, num2);
            break;
        default:
            printf("Error: Unsupported operation '%c'\n", operation);
            *result = 0;
            break;
    }
}

void display_menu() {
    printf("\n--- Scientific Calculator ---\n");
    printf("Enter a number: ");
}

void clear_buffer() {
    int c;
    while ((c = getchar()) != '\n' && c != EOF) {}
}