//GPT-4o-mini DATASET v1.0 Category: Networking ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>

#define PORT 8080
#define MAX_CLIENTS 10
#define BUFFER_SIZE 1024

void handle_client(int client_sock) {
    char buffer[BUFFER_SIZE];
    int read_size;

    while ((read_size = recv(client_sock, buffer, sizeof(buffer) - 1, 0)) > 0) {
        buffer[read_size] = '\0'; // Null terminate the received data
        printf("Client message: %s", buffer);
        
        // Echo the message back to the client
        send(client_sock, buffer, read_size, 0);
    }

    if (read_size == 0) {
        printf("Client disconnected\n");
    } else {
        perror("recv failed");
    }

    close(client_sock);
}

int main() {
    int server_sock, client_sock, addr_len;
    struct sockaddr_in address;
    fd_set readfds;
    int max_sd;

    // Create socket
    if ((server_sock = socket(AF_INET, SOCK_STREAM, 0)) == 0) {
        perror("Socket creation error");
        exit(EXIT_FAILURE);
    }

    // Set up the address structure
    address.sin_family = AF_INET;
    address.sin_addr.s_addr = INADDR_ANY;
    address.sin_port = htons(PORT);

    // Bind the socket to the port
    if (bind(server_sock, (struct sockaddr *)&address, sizeof(address)) < 0) {
        perror("Bind failed");
        exit(EXIT_FAILURE);
    }

    // Start listening for incoming connections
    if (listen(server_sock, 3) < 0) {
        perror("Listen failed");
        exit(EXIT_FAILURE);
    }

    printf("Chat server started on port %d\n", PORT);

    while (1) {
        // Clear the socket set and add the server socket to it
        FD_ZERO(&readfds);
        FD_SET(server_sock, &readfds);
        max_sd = server_sock;

        // Add child sockets
        int i;
        for (i = 0; i < MAX_CLIENTS; i++) {
            if (i > 0) {
                int sock = i;
                FD_SET(sock, &readfds);
                if (sock > max_sd) {
                    max_sd = sock;
                }
            }
        }

        // Wait for an activity on one of the sockets
        int activity = select(max_sd + 1, &readfds, NULL, NULL, NULL);

        if (activity < 0) {
            perror("Select error");
            exit(EXIT_FAILURE);
        }

        // If something happened on the master socket, then it's an incoming connection
        if (FD_ISSET(server_sock, &readfds)) {
            addr_len = sizeof(address);
            if ((client_sock = accept(server_sock, (struct sockaddr *)&address, (socklen_t*)&addr_len)) < 0) {
                perror("Accept failed");
                exit(EXIT_FAILURE);
            }
            printf("New connection, socket fd is %d, ip is : %s, port : %d\n", client_sock,
                   inet_ntoa(address.sin_addr), ntohs(address.sin_port));
            // Handle client in a new thread or function (not implemented in this example)
            handle_client(client_sock);
        }
    }

    return 0;
}