//GPT-4o-mini DATASET v1.0 Category: Checkers Game ; Style: medieval
#include <stdio.h>
#include <stdlib.h>

#define SIZE 8
#define EMPTY ' '
#define WHITE 'W'
#define BLACK 'B'

typedef struct {
    char board[SIZE][SIZE];
    char currentPlayer;
} Game;

void initializeBoard(Game *game) {
    for (int row = 0; row < SIZE; row++) {
        for (int col = 0; col < SIZE; col++) {
            if (row % 2 == 0) {
                if (col % 2 == 1 && row < 3) {
                    game->board[row][col] = BLACK;
                } else if (col % 2 == 1 && row > 4) {
                    game->board[row][col] = WHITE;
                } else {
                    game->board[row][col] = EMPTY;
                }
            } else {
                if (col % 2 == 0 && row < 3) {
                    game->board[row][col] = BLACK;
                } else if (col % 2 == 0 && row > 4) {
                    game->board[row][col] = WHITE;
                } else {
                    game->board[row][col] = EMPTY;
                }
            }
        }
    }
    game->currentPlayer = WHITE; // White starts the game
}

void displayBoard(Game *game) {
    printf("   A B C D E F G H\n");
    printf("  +----------------+\n");
    for (int row = 0; row < SIZE; row++) {
        printf("%d |", row + 1);
        for (int col = 0; col < SIZE; col++) {
            printf("%c|", game->board[row][col]);
        }
        printf("\n  +----------------+\n");
    }
    printf("Current Player: %c\n", game->currentPlayer);
}

int isValidMove(int sr, int sc, int dr, int dc, Game *game) {
    if (dr < 0 || dr >= SIZE || dc < 0 || dc >= SIZE) return 0; // Out of bounds
    if (game->board[dr][dc] != EMPTY) return 0; // Destination must be empty

    char movingPiece = game->board[sr][sc];
    if (movingPiece == game->currentPlayer) {
        // Check for simple move
        if (abs(sr - dr) == 1 && abs(sc - dc) == 1) return 1;
        // Check for capture move
        if (abs(sr - dr) == 2 && abs(sc - dc) == 2) {
            int midRow = (sr + dr) / 2;
            int midCol = (sc + dc) / 2;
            char midPiece = game->board[midRow][midCol];
            if (midPiece != EMPTY && midPiece != game->currentPlayer) return 1; // Valid capture
        }
    }
    return 0;
}

void makeMove(int sr, int sc, int dr, int dc, Game *game) {
    // Capture logic
    if (abs(sr - dr) == 2 && abs(sc - dc) == 2) {
        int midRow = (sr + dr) / 2;
        int midCol = (sc + dc) / 2;
        game->board[midRow][midCol] = EMPTY; // Remove captured piece
    }
    // Move the piece
    game->board[dr][dc] = game->board[sr][sc];
    game->board[sr][sc] = EMPTY;
}

void switchPlayer(Game *game) {
    game->currentPlayer = (game->currentPlayer == WHITE) ? BLACK : WHITE;
}

int main() {
    Game game;
    int sr, sc, dr, dc;
    char srcCol, destCol;

    initializeBoard(&game);
    displayBoard(&game);

    while (1) {
        printf("Player %c, enter your move (e.g., A3 B4): ", game.currentPlayer);
        scanf(" %c%d %c%d", &srcCol, &sr, &destCol, &dr);
        sc = srcCol - 'A';
        dr -= 1; sr -= 1; dc = destCol - 'A';

        if (isValidMove(sr, sc, dr, dc, &game)) {
            makeMove(sr, sc, dr, dc, &game);
            displayBoard(&game);
            switchPlayer(&game);
        } else {
            printf("Invalid move. Try again.\n");
        }
    }

    return 0;
}