//GEMINI-pro DATASET v1.0 Category: Terminal Based Game ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the game board size
#define BOARD_SIZE 10

// Define the player symbols
#define PLAYER_1 'X'
#define PLAYER_2 'O'

// Define the game state
#define GAME_STATE_IN_PROGRESS 0
#define GAME_STATE_PLAYER_1_WON 1
#define GAME_STATE_PLAYER_2_WON 2
#define GAME_STATE_DRAW 3

// Function to initialize the game board
void initialize_board(char board[][BOARD_SIZE]) {
  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      board[i][j] = ' ';
    }
  }
}

// Function to print the game board
void print_board(char board[][BOARD_SIZE]) {
  printf("  ");
  for (int i = 0; i < BOARD_SIZE; i++) {
    printf("%d ", i + 1);
  }
  printf("\n");

  for (int i = 0; i < BOARD_SIZE; i++) {
    printf("%d ", i + 1);
    for (int j = 0; j < BOARD_SIZE; j++) {
      printf("| %c ", board[i][j]);
    }
    printf("|\n");
  }
}

// Function to check if a move is valid
int is_valid_move(char board[][BOARD_SIZE], int row, int col) {
  return board[row][col] == ' ';
}

// Function to make a move
void make_move(char board[][BOARD_SIZE], int row, int col, char player_symbol) {
  board[row][col] = player_symbol;
}

// Function to check if the game is over
int is_game_over(char board[][BOARD_SIZE]) {
  // Check for horizontal wins
  for (int i = 0; i < BOARD_SIZE; i++) {
    if (board[i][0] != ' ' && board[i][0] == board[i][1] && board[i][1] == board[i][2]) {
      return board[i][0] == PLAYER_1 ? GAME_STATE_PLAYER_1_WON : GAME_STATE_PLAYER_2_WON;
    }
  }

  // Check for vertical wins
  for (int i = 0; i < BOARD_SIZE; i++) {
    if (board[0][i] != ' ' && board[0][i] == board[1][i] && board[1][i] == board[2][i]) {
      return board[0][i] == PLAYER_1 ? GAME_STATE_PLAYER_1_WON : GAME_STATE_PLAYER_2_WON;
    }
  }

  // Check for diagonal wins
  if (board[0][0] != ' ' && board[0][0] == board[1][1] && board[1][1] == board[2][2]) {
    return board[0][0] == PLAYER_1 ? GAME_STATE_PLAYER_1_WON : GAME_STATE_PLAYER_2_WON;
  }
  if (board[0][2] != ' ' && board[0][2] == board[1][1] && board[1][1] == board[2][0]) {
    return board[0][2] == PLAYER_1 ? GAME_STATE_PLAYER_1_WON : GAME_STATE_PLAYER_2_WON;
  }

  // Check for draw
  int num_empty_cells = 0;
  for (int i = 0; i < BOARD_SIZE; i++) {
    for (int j = 0; j < BOARD_SIZE; j++) {
      if (board[i][j] == ' ') {
        num_empty_cells++;
      }
    }
  }

  return num_empty_cells == 0 ? GAME_STATE_DRAW : GAME_STATE_IN_PROGRESS;
}

// Function to get the next player symbol
char get_next_player_symbol(char current_player_symbol) {
  return current_player_symbol == PLAYER_1 ? PLAYER_2 : PLAYER_1;
}

// Function to play the game
void play_game() {
  // Initialize the game board
  char board[BOARD_SIZE][BOARD_SIZE];
  initialize_board(board);

  // Set the current player symbol to player 1
  char current_player_symbol = PLAYER_1;

  // Continue playing the game until it is over
  int game_state = GAME_STATE_IN_PROGRESS;
  while (game_state == GAME_STATE_IN_PROGRESS) {
    // Print the game board
    print_board(board);

    // Get the player's move
    int row, col;
    printf("Enter your move (row, col): ");
    scanf("%d %d", &row, &col);

    // Check if the move is valid
    if (!is_valid_move(board, row - 1, col - 1)) {
      printf("Invalid move. Please try again.\n");
      continue;
    }

    // Make the move
    make_move(board, row - 1, col - 1, current_player_symbol);

    // Check if the game is over
    game_state = is_game_over(board);

    // Switch to the next player
    current_player_symbol = get_next_player_symbol(current_player_symbol);
  }

  // Print the final game board
  print_board(board);

  // Announce the game result
  switch (game_state) {
    case GAME_STATE_PLAYER_1_WON:
      printf("Player 1 wins!\n");
      break;
    case GAME_STATE_PLAYER_2_WON:
      printf("Player 2 wins!\n");
      break;
    case GAME_STATE_DRAW:
      printf("Draw!\n");
      break;
  }
}

int main() {
  // Seed the random number generator
  srand(time(NULL));

  // Play the game
  play_game();

  return 0;
}