//Falcon-180B DATASET v1.0 Category: Sudoku solver ; Style: automated
#include<stdio.h>
#include<stdlib.h>
#include<time.h>
#define SIZE 9

int main(){
    int board[SIZE][SIZE],i,j,k,temp,flag=0;
    int start_time,end_time;
    srand(time(NULL));
    
    for(i=0;i<SIZE;i++){
        for(j=0;j<SIZE;j++){
            board[i][j]=0;
        }
    }
    
    for(i=0;i<SIZE;i++){
        for(j=0;j<SIZE;j++){
            if(board[i][j]==0){
                board[i][j]=1+rand()%9;
            }
        }
    }
    
    printf("Initial Board:\n");
    for(i=0;i<SIZE;i++){
        for(j=0;j<SIZE;j++){
            printf("%d ",board[i][j]);
        }
        printf("\n");
    }
    
    start_time=clock();
    for(i=0;i<SIZE;i++){
        for(j=0;j<SIZE;j++){
            if(board[i][j]==0){
                for(k=1;k<=9;k++){
                    if(is_valid(board,i,j,k)){
                        board[i][j]=k;
                        flag=1;
                        break;
                    }
                }
                if(flag==0){
                    board[i][j]=0;
                }
                flag=0;
            }
        }
    }
    
    end_time=clock();
    printf("Time taken to solve the puzzle: %f seconds\n",((double)(end_time-start_time))/CLOCKS_PER_SEC);
    
    printf("\nFinal Board:\n");
    for(i=0;i<SIZE;i++){
        for(j=0;j<SIZE;j++){
            printf("%d ",board[i][j]);
        }
        printf("\n");
    }
    
    return 0;
}

int is_valid(int board[SIZE][SIZE],int i,int j,int num){
    int x,y;
    x=i-i%3;
    y=j-j%3;
    for(int k=0;k<3;k++){
        for(int l=0;l<3;l++){
            if(board[x+k][y+l]==num){
                return 0;
            }
        }
    }
    return 1;
}