//GEMINI-pro DATASET v1.0 Category: Bucket Sort Implementation ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>

#define BUCKET_COUNT 10

typedef struct bucket_node {
    int value;
    struct bucket_node *next;
} bucket_node;

typedef struct bucket {
    bucket_node *head;
    bucket_node *tail;
} bucket;

void bucket_sort(int *arr, int len) {
    bucket buckets[BUCKET_COUNT];

    // Initialize buckets
    for (int i = 0; i < BUCKET_COUNT; i++) {
        buckets[i].head = NULL;
        buckets[i].tail = NULL;
    }

    // Distribute elements into buckets
    for (int i = 0; i < len; i++) {
        int bucket_index = arr[i] / BUCKET_COUNT;
        bucket_node *new_node = malloc(sizeof(bucket_node));
        new_node->value = arr[i];
        new_node->next = NULL;

        if (buckets[bucket_index].head == NULL) {
            buckets[bucket_index].head = new_node;
            buckets[bucket_index].tail = new_node;
        } else {
            buckets[bucket_index].tail->next = new_node;
            buckets[bucket_index].tail = new_node;
        }
    }

    // Sort each bucket
    for (int i = 0; i < BUCKET_COUNT; i++) {
        bucket_node *current = buckets[i].head;
        while (current != NULL) {
            bucket_node *min_node = current;
            bucket_node *min_prev = NULL;
            bucket_node *next = current->next;

            while (next != NULL) {
                if (next->value < min_node->value) {
                    min_node = next;
                    min_prev = current;
                }
                current = current->next;
                next = next->next;
            }

            if (min_node != current) {
                if (min_prev != NULL) {
                    min_prev->next = min_node->next;
                } else {
                    buckets[i].head = min_node->next;
                }

                min_node->next = current->next;
                current->next = min_node;
            }

            current = current->next;
        }
    }

    // Merge buckets into sorted array
    int index = 0;
    for (int i = 0; i < BUCKET_COUNT; i++) {
        bucket_node *current = buckets[i].head;
        while (current != NULL) {
            arr[index++] = current->value;
            current = current->next;
        }
    }
}

int main() {
    int arr[] = {5, 3, 1, 7, 4, 1, 2, 8, 6};
    int len = sizeof(arr) / sizeof(arr[0]);

    bucket_sort(arr, len);

    for (int i = 0; i < len; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");

    return 0;
}