//GEMINI-pro DATASET v1.0 Category: Smart home light control ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

// Define the maximum number of lights
#define MAX_LIGHTS 10

// Define the light states
typedef enum {
    LIGHT_OFF,
    LIGHT_ON
} light_state;

// Define the light data structure
typedef struct {
    char *name;
    light_state state;
} light;

// Create an array of lights
light lights[MAX_LIGHTS];

// Initialize the lights
void init_lights() {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        lights[i].name = NULL;
        lights[i].state = LIGHT_OFF;
    }
}

// Add a new light
void add_light(char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (lights[i].name == NULL) {
            lights[i].name = strdup(name);
            lights[i].state = LIGHT_OFF;
            break;
        }
    }
}

// Delete a light
void delete_light(char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            free(lights[i].name);
            lights[i].name = NULL;
            lights[i].state = LIGHT_OFF;
            break;
        }
    }
}

// Turn a light on
void turn_on_light(char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].state = LIGHT_ON;
            break;
        }
    }
}

// Turn a light off
void turn_off_light(char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].state = LIGHT_OFF;
            break;
        }
    }
}

// Get the state of a light
light_state get_light_state(char *name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            return lights[i].state;
        }
    }

    return LIGHT_OFF;
}

// Print the status of all lights
void print_lights() {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (lights[i].name != NULL) {
            printf("%s: %s\n", lights[i].name, lights[i].state == LIGHT_ON ? "ON" : "OFF");
        }
    }
}

// Main function
int main() {
    // Initialize the lights
    init_lights();

    // Add some lights
    add_light("Living Room");
    add_light("Kitchen");
    add_light("Bedroom");

    // Turn on the living room light
    turn_on_light("Living Room");

    // Turn off the kitchen light
    turn_off_light("Kitchen");

    // Print the status of all lights
    print_lights();

    return 0;
}