//GEMINI-pro DATASET v1.0 Category: Scientific Calculator Implementation ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Function to calculate the mean of an array of numbers
double mean(double *data, int n) {
  double sum = 0;
  for (int i = 0; i < n; i++) {
    sum += data[i];
  }
  return sum / n;
}

// Function to calculate the standard deviation of an array of numbers
double stddev(double *data, int n) {
  double mean_value = mean(data, n);
  double sum_of_squared_differences = 0;
  for (int i = 0; i < n; i++) {
    sum_of_squared_differences += pow(data[i] - mean_value, 2);
  }
  return sqrt(sum_of_squared_differences / (n - 1));
}

// Function to calculate the median of an array of numbers
double median(double *data, int n) {
  // Sort the array in ascending order
  for (int i = 0; i < n - 1; i++) {
    for (int j = i + 1; j < n; j++) {
      if (data[j] < data[i]) {
        double temp = data[i];
        data[i] = data[j];
        data[j] = temp;
      }
    }
  }

  // If the array has an even number of elements, the median is the average of the two middle elements
  if (n % 2 == 0) {
    return (data[n / 2] + data[n / 2 - 1]) / 2;
  }
  // If the array has an odd number of elements, the median is the middle element
  else {
    return data[n / 2];
  }
}

// Function to calculate the mode of an array of numbers
double mode(double *data, int n) {
  // Create an array to store the counts of each unique value in the data array
  int *counts = calloc(n, sizeof(int));

  // Count the occurrences of each unique value in the data array
  for (int i = 0; i < n; i++) {
    int count = 0;
    for (int j = 0; j < n; j++) {
      if (data[i] == data[j]) {
        count++;
      }
    }
    counts[i] = count;
  }

  // Find the index of the value with the highest count
  int max_index = 0;
  for (int i = 1; i < n; i++) {
    if (counts[i] > counts[max_index]) {
      max_index = i;
    }
  }

  // Return the value with the highest count
  return data[max_index];
}

// Function to print the statistical summary of an array of numbers
void print_summary(double *data, int n) {
  printf("Mean: %.2f\n", mean(data, n));
  printf("Standard deviation: %.2f\n", stddev(data, n));
  printf("Median: %.2f\n", median(data, n));
  printf("Mode: %.2f\n", mode(data, n));
}

int main() {
  // Define an array of numbers
  double data[] = {1.2, 2.3, 3.4, 4.5, 5.6, 6.7, 7.8, 8.9, 9.0, 10.1};

  // Print the statistical summary of the array
  print_summary(data, 10);

  return 0;
}