//Falcon-180B DATASET v1.0 Category: Fitness Tracker ; Style: inquisitive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_ENTRIES 100

typedef struct {
    char name[50];
    int duration;
    int calories;
    time_t start_time;
    time_t end_time;
} entry_t;

entry_t entries[MAX_ENTRIES];
int num_entries = 0;

void add_entry(char* name, int duration, int calories) {
    if (num_entries >= MAX_ENTRIES) {
        printf("Error: Maximum number of entries reached.\n");
        return;
    }

    entry_t new_entry = {
       .name = strdup(name),
       .duration = duration,
       .calories = calories
    };

    time(&new_entry.start_time);
    new_entry.end_time = 0;

    memcpy(&entries[num_entries], &new_entry, sizeof(entry_t));
    num_entries++;

    printf("Entry added: %s\n", name);
}

void remove_entry(int index) {
    if (index < 0 || index >= num_entries) {
        printf("Error: Invalid entry index.\n");
        return;
    }

    free(entries[index].name);

    for (int i = index; i < num_entries - 1; i++) {
        memcpy(&entries[i], &entries[i+1], sizeof(entry_t));
    }

    num_entries--;

    printf("Entry removed: %d\n", index);
}

void view_entries() {
    if (num_entries == 0) {
        printf("No entries found.\n");
        return;
    }

    for (int i = 0; i < num_entries; i++) {
        if (entries[i].end_time == 0) {
            printf("Entry %d is still in progress...\n", i);
        } else {
            int duration = difftime(entries[i].end_time, entries[i].start_time);
            int calories_burned = duration * (entries[i].calories / 60);

            printf("Entry %d: %s\nDuration: %d minutes\nCalories burned: %d\n", i, entries[i].name, duration, calories_burned);
        }
    }
}

int main() {
    srand(time(NULL));

    add_entry("Running", 30, 300);
    add_entry("Swimming", 60, 600);

    view_entries();

    remove_entry(0);

    view_entries();

    return 0;
}