//MISTRAL-7B DATASET v1.0 Category: Warehouse Management System ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define TABLE_SIZE 101

typedef struct {
    char name[50];
    int quantity;
} Item;

typedef struct HashNode {
    Item item;
    struct HashNode *next;
} HashNode;

HashNode *table[TABLE_SIZE];

void init_table() {
    int i;
    for (i = 0; i < TABLE_SIZE; i++) {
        table[i] = NULL;
    }
}

int hash(char *str) {
    int hash = 0;
    while (*str) {
        hash = (*str++) + (hash << 5) + hash;
    }
    return hash % TABLE_SIZE;
}

void add_item(char *name, int quantity) {
    Item new_item = {name, quantity};
    HashNode *new_node = (HashNode *)malloc(sizeof(HashNode));
    new_node->item = new_item;

    int index = hash(name);
    new_node->next = table[index];
    table[index] = new_node;
}

void remove_item(char *name) {
    int index = hash(name);
    HashNode *prev = NULL, *current = table[index];

    while (current != NULL && strcmp(current->item.name, name) != 0) {
        prev = current;
        current = current->next;
    }

    if (current == NULL) {
        printf("Item not found.\n");
        return;
    }

    if (prev == NULL) {
        table[index] = current->next;
    } else {
        prev->next = current->next;
    }

    free(current);
}

void view_inventory() {
    int i;

    for (i = 0; i < TABLE_SIZE; i++) {
        HashNode *current = table[i];

        if (current != NULL) {
            printf("%s: %d\n", current->item.name, current->item.quantity);
        }
    }
}

int main() {
    init_table();
    add_item("Laptop", 10);
    add_item("Monitor", 5);
    add_item("Printer", 3);

    view_inventory();

    remove_item("Monitor");

    view_inventory();

    remove_item("Laptop");

    view_inventory();

    return 0;
}