//Code Llama-13B DATASET v1.0 Category: Spam Detection System ; Style: protected
// C Spam Detection System
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

// Define the spam words
const char* spam_words[] = { "buy", "sale", "discount", "offer", "promotion" };

// Function to check if a word is a spam word
bool is_spam_word(const char* word) {
    for (int i = 0; i < sizeof(spam_words) / sizeof(spam_words[0]); i++) {
        if (strcmp(word, spam_words[i]) == 0) {
            return true;
        }
    }
    return false;
}

// Function to check if a message is spam
bool is_spam(const char* message) {
    // Convert the message to lowercase
    char* lowercase_message = strdup(message);
    for (int i = 0; i < strlen(lowercase_message); i++) {
        lowercase_message[i] = tolower(lowercase_message[i]);
    }

    // Check if any of the words in the message are spam words
    char* word = strtok(lowercase_message, " ");
    while (word != NULL) {
        if (is_spam_word(word)) {
            return true;
        }
        word = strtok(NULL, " ");
    }

    // If no spam words are found, the message is not spam
    return false;
}

// Example usage
int main() {
    char* message = "Hello, how are you?";
    if (is_spam(message)) {
        printf("Spam detected\n");
    } else {
        printf("Not spam\n");
    }
    return 0;
}