//GEMINI-pro DATASET v1.0 Category: Clustering Algorithm Implementation ; Style: Dennis Ritchie
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

typedef struct {
    double x;
    double y;
} point;

typedef struct {
    point* points;
    int n;
} cluster;

double distance(point a, point b) {
    return sqrt(pow(a.x - b.x, 2) + pow(a.y - b.y, 2));
}

cluster* create_cluster(int n) {
    cluster* c = malloc(sizeof(cluster));
    c->points = malloc(n * sizeof(point));
    c->n = n;
    return c;
}

void free_cluster(cluster* c) {
    free(c->points);
    free(c);
}

void add_point(cluster* c, point p) {
    c->points[c->n++] = p;
}

cluster* merge_clusters(cluster* a, cluster* b) {
    cluster* c = create_cluster(a->n + b->n);
    int i;
    for (i = 0; i < a->n; i++) {
        add_point(c, a->points[i]);
    }
    for (i = 0; i < b->n; i++) {
        add_point(c, b->points[i]);
    }
    free_cluster(a);
    free_cluster(b);
    return c;
}

cluster* cluster_points(point* points, int n, double threshold) {
    cluster** clusters = malloc(n * sizeof(cluster*));
    int i, j;
    for (i = 0; i < n; i++) {
        clusters[i] = create_cluster(1);
        add_point(clusters[i], points[i]);
    }
    while (1) {
        int merged = 0;
        for (i = 0; i < n; i++) {
            for (j = i + 1; j < n; j++) {
                if (distance(clusters[i]->points[0], clusters[j]->points[0]) < threshold) {
                    clusters[i] = merge_clusters(clusters[i], clusters[j]);
                    n--;
                    merged = 1;
                    break;
                }
            }
            if (merged) {
                break;
            }
        }
        if (!merged) {
            break;
        }
    }
    cluster* result = clusters[0];
    for (i = 1; i < n; i++) {
        free_cluster(clusters[i]);
    }
    free(clusters);
    return result;
}

int main() {
    int n;
    scanf("%d", &n);
    point* points = malloc(n * sizeof(point));
    int i;
    for (i = 0; i < n; i++) {
        scanf("%lf %lf", &points[i].x, &points[i].y);
    }
    double threshold;
    scanf("%lf", &threshold);
    cluster* c = cluster_points(points, n, threshold);
    printf("%d\n", c->n);
    for (i = 0; i < c->n; i++) {
        printf("%lf %lf\n", c->points[i].x, c->points[i].y);
    }
    free_cluster(c);
    free(points);
    return 0;
}