//LLAMA2-13B DATASET v1.0 Category: Linked list operations ; Style: safe
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to represent a node in the linked list
struct Node {
    int data;
    struct Node *next;
};

// Function to create a new node with the given data
struct Node* newNode(int data) {
    struct Node* node = malloc(sizeof(struct Node));
    node->data = data;
    node->next = NULL;
    return node;
}

// Function to print the linked list
void printList(struct Node* head) {
    while (head != NULL) {
        printf("%d ", head->data);
        head = head->next;
    }
    printf("\n");
}

// Function to insert a node at the beginning of the list
struct Node* insertAtBeginning(struct Node** head_ref, int data) {
    struct Node* new_node = newNode(data);
    new_node->next = *head_ref;
    *head_ref = new_node;
    return new_node;
}

// Function to insert a node at the end of the list
struct Node* insertAtEnd(struct Node** head_ref, int data) {
    struct Node* current = *head_ref;
    struct Node* new_node = newNode(data);

    while (current->next != NULL) {
        current = current->next;
    }

    current->next = new_node;
    new_node->next = NULL;

    return new_node;
}

// Function to remove the first node from the list
struct Node* removeFirst(struct Node** head_ref) {
    if (*head_ref == NULL) {
        return NULL;
    }

    struct Node* first = *head_ref;
    *head_ref = first->next;

    free(first);
    return first;
}

// Function to remove the last node from the list
struct Node* removeLast(struct Node** head_ref) {
    struct Node* current = *head_ref;

    while (current->next != NULL) {
        current = current->next;
    }

    if (current->next == NULL) {
        return NULL;
    }

    struct Node* last = current;
    current->next = NULL;

    free(last);
    return last;
}

int main() {
    struct Node* head = NULL;

    // Insert nodes at the beginning of the list
    head = insertAtBeginning(&head, 1);
    head = insertAtBeginning(&head, 2);
    head = insertAtBeginning(&head, 3);

    // Insert nodes at the end of the list
    head = insertAtEnd(&head, 4);
    head = insertAtEnd(&head, 5);
    head = insertAtEnd(&head, 6);

    // Remove nodes from the list
    head = removeFirst(&head);
    head = removeFirst(&head);
    head = removeLast(&head);

    // Print the list
    printList(head);

    return 0;
}