//GEMINI-pro DATASET v1.0 Category: Building a CSV Reader ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define BUFFER_SIZE 1024

typedef struct {
    char *data;
    size_t size;
    size_t capacity;
} CSVRow;

typedef struct {
    FILE *fp;
    char *buffer;
    size_t buffer_size;
    size_t buffer_index;
    CSVRow row;
} CSVReader;

CSVReader *csv_reader_new(FILE *fp) {
    CSVReader *reader = malloc(sizeof(CSVReader));
    if (!reader) {
        return NULL;
    }

    reader->fp = fp;
    reader->buffer = malloc(BUFFER_SIZE);
    if (!reader->buffer) {
        free(reader);
        return NULL;
    }

    reader->buffer_size = BUFFER_SIZE;
    reader->buffer_index = 0;

    reader->row.data = NULL;
    reader->row.size = 0;
    reader->row.capacity = 0;

    return reader;
}

void csv_reader_free(CSVReader *reader) {
    if (!reader) {
        return;
    }

    if (reader->buffer) {
        free(reader->buffer);
    }

    if (reader->row.data) {
        free(reader->row.data);
    }

    free(reader);
}

int csv_reader_read_row(CSVReader *reader) {
    if (!reader || !reader->fp) {
        return -1;
    }

    reader->row.size = 0;
    reader->row.data = NULL;

    int c;
    while ((c = fgetc(reader->fp)) != EOF) {
        if (c == '\n' || c == '\r') {
            break;
        }

        if (reader->row.size >= reader->row.capacity) {
            reader->row.capacity = reader->row.capacity ? reader->row.capacity * 2 : 16;
            reader->row.data = realloc(reader->row.data, reader->row.capacity);
            if (!reader->row.data) {
                return -1;
            }
        }

        reader->row.data[reader->row.size++] = c;
    }

    return 0;
}

char *csv_reader_get_row(CSVReader *reader) {
    if (!reader) {
        return NULL;
    }

    return reader->row.data;
}

size_t csv_reader_get_row_size(CSVReader *reader) {
    if (!reader) {
        return 0;
    }

    return reader->row.size;
}

int main() {
    FILE *fp = fopen("data.csv", "r");
    if (!fp) {
        perror("fopen");
        return EXIT_FAILURE;
    }

    CSVReader *reader = csv_reader_new(fp);
    if (!reader) {
        perror("csv_reader_new");
        fclose(fp);
        return EXIT_FAILURE;
    }

    while (csv_reader_read_row(reader) == 0) {
        char *row = csv_reader_get_row(reader);
        size_t size = csv_reader_get_row_size(reader);

        printf("Row: %s, Size: %zu\n", row, size);
    }

    csv_reader_free(reader);
    fclose(fp);

    return EXIT_SUCCESS;
}