//GEMINI-pro DATASET v1.0 Category: Music Library Management System ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

typedef struct song {
    char *title;
    char *artist;
    char *album;
    int year;
    int length;
} Song;

typedef struct library {
    Song **songs;
    int num_songs;
} Library;

Library *create_library() {
    Library *library = (Library *)malloc(sizeof(Library));
    library->songs = (Song **)malloc(0);
    library->num_songs = 0;
    return library;
}

void add_song_to_library(Library *library, Song *song) {
    library->songs = (Song **)realloc(library->songs, (library->num_songs + 1) * sizeof(Song *));
    library->songs[library->num_songs++] = song;
}

void print_library(Library *library) {
    for (int i = 0; i < library->num_songs; i++) {
        Song *song = library->songs[i];
        printf("%s by %s from %d (%d seconds)\n", song->title, song->artist, song->year, song->length);
    }
}

int main() {
    // Create a new library
    Library *library = create_library();

    // Add some songs to the library
    add_song_to_library(library, (Song *)malloc(sizeof(Song)));
    strcpy(library->songs[library->num_songs - 1]->title, "Bohemian Rhapsody");
    strcpy(library->songs[library->num_songs - 1]->artist, "Queen");
    library->songs[library->num_songs - 1]->year = 1975;
    library->songs[library->num_songs - 1]->length = 360;

    add_song_to_library(library, (Song *)malloc(sizeof(Song)));
    strcpy(library->songs[library->num_songs - 1]->title, "Stairway to Heaven");
    strcpy(library->songs[library->num_songs - 1]->artist, "Led Zeppelin");
    library->songs[library->num_songs - 1]->year = 1971;
    library->songs[library->num_songs - 1]->length = 480;

    add_song_to_library(library, (Song *)malloc(sizeof(Song)));
    strcpy(library->songs[library->num_songs - 1]->title, "Hotel California");
    strcpy(library->songs[library->num_songs - 1]->artist, "Eagles");
    library->songs[library->num_songs - 1]->year = 1976;
    library->songs[library->num_songs - 1]->length = 390;

    // Print the library
    print_library(library);

    return 0;
}