//GEMINI-pro DATASET v1.0 Category: Wireless Network Scanner ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <net/if.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/types.h>
#include <netinet/in.h>

#define IFLIST_BUFFER_SIZE 1024

struct iflist {
    struct iflist *next;
    struct ifreq ifr;
};

struct iflist *get_iflist(void) {
    int sockfd;
    struct iflist *iflist = NULL, *last = NULL;
    struct ifreq ifr;

    sockfd = socket(AF_INET, SOCK_DGRAM, 0);
    if (sockfd == -1) {
        perror("socket");
        return NULL;
    }

    memset(&ifr, 0, sizeof(ifr));

    for (last = NULL; if_indextoname(0, &ifr.ifr_name) != NULL; last = iflist) {
        iflist = malloc(sizeof(struct iflist));
        if (iflist == NULL) {
            perror("malloc");
            return NULL;
        }
        memcpy(&iflist->ifr, &ifr, sizeof(ifr));
        if (last != NULL) {
            last->next = iflist;
        }
    }

    close(sockfd);

    return iflist;
}

void print_iflist(struct iflist *iflist) {
    while (iflist != NULL) {
        printf("%s\n", iflist->ifr.ifr_name);
        iflist = iflist->next;
    }
}

void free_iflist(struct iflist *iflist) {
    while (iflist != NULL) {
        struct iflist *next = iflist->next;
        free(iflist);
        iflist = next;
    }
}

int main(void) {
    struct iflist *iflist = get_iflist();
    if (iflist == NULL) {
        fprintf(stderr, "Error: could not get interface list\n");
        return 1;
    }

    printf("Interface list:\n");
    print_iflist(iflist);

    free_iflist(iflist);

    return 0;
}