//MISTRAL-7B DATASET v1.0 Category: Linked list operations ; Style: cheerful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

// Define the Node structure
typedef struct Node {
    int data;
    char *name;
    struct Node *next;
} Node;

// Initialize the Linked List
void initList(Node **head) {
    printf("Yippee! List is being born!\n");
    *head = NULL;
}

// Insert a new Node at the Head of the List
void insertAtHead(Node **head, int data, char *name) {
    Node *newNode = (Node *) malloc(sizeof(Node));

    if (newNode == NULL) {
        printf("Oops! Memory error! List cannot be born!\n");
        return;
    }

    newNode->data = data;
    newNode->name = name;
    newNode->next = *head;
    *head = newNode;

    printf("Hurray! New Node added to the Head!\n");
}

// Insert a new Node at the Tail of the List
void insertAtTail(Node **head, int data, char *name) {
    Node *newNode = (Node *) malloc(sizeof(Node));
    Node *current = *head;

    if (newNode == NULL) {
        printf("Oops! Memory error! Node cannot be born!\n");
        return;
    }

    newNode->data = data;
    newNode->name = name;
    newNode->next = NULL;

    if (*head == NULL) {
        *head = newNode;
        printf("Hip Hip Hurray! List is born with a new Node!\n");
        return;
    }

    while (current->next != NULL) {
        current = current->next;
    }

    current->next = newNode;
    printf("Yay! New Node added to the Tail!\n");
}

// Print the Data and Name of the Nodes in the List
void printList(Node *head) {
    printf("\nList contents:\n");

    while (head != NULL) {
        printf("Data: %d Name: %s -> ", head->data, head->name);
        head = head->next;
    }

    printf("NULL\n");
}

// Delete a Node with the given Data from the List
void deleteNode(Node **head, int data) {
    Node *current = *head, *previous = NULL;

    while (current != NULL && current->data == data) {
        *head = current->next;
        free(current);
        printf("Yippee! Node with Data %d and Name %s deleted!\n", current->data, current->name);
        current = *head;
    }

    while (current != NULL) {
        if (previous == NULL) {
            previous = current;
        }

        if (current->data != data) {
            previous = current;
        }

        if (previous == NULL) {
            printf("Uh Oh! Data %d not found in the List!\n", data);
            return;
        }

        Node *temp = current->next;
        free(current);
        previous->next = temp;
        printf("Deleted Node: Data: %d Name: %s\n", current->data, current->name);
        current = temp;
    }
}

int main() {
    Node *head = NULL;
    initList(&head);
    insertAtHead(&head, 1, "One");
    insertAtTail(&head, 2, "Two");
    insertAtTail(&head, 3, "Three");
    printList(head);
    deleteNode(&head, 2);
    printList(head);

    return 0;
}