//GPT-4o-mini DATASET v1.0 Category: Traffic Flow Simulation ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

#define MAX_VEHICLES 10
#define TIME_STEP 2 // Time step in seconds
#define NUM_STEPS 30 // Total simulation time steps

typedef enum {
    RED,
    GREEN,
    YELLOW
} TrafficLight;

typedef struct {
    int vehicles;
    TrafficLight light;
} Intersection;

void updateTrafficLight(Intersection* intersection, int step) {
    if (intersection->light == GREEN) {
        if (step % 10 == 0) {
            intersection->light = YELLOW;
        }
    } else if (intersection->light == YELLOW) {
        if (step % 2 == 0) {
            intersection->light = RED;
        }
    } else if (intersection->light == RED) {
        if (step % 10 == 0) {
            intersection->light = GREEN;
        }
    }
}

void simulateTraffic(Intersection* intersection, int step) {
    if (intersection->light == GREEN) {
        intersection->vehicles = rand() % (MAX_VEHICLES + 1); // Vehicles can range from 0 to MAX_VEHICLES
        printf("Step %d: Light is GREEN - %d vehicles passed.\n", step, intersection->vehicles);
    } else if (intersection->light == YELLOW) {
        printf("Step %d: Light is YELLOW - Slow down! No vehicles can pass.\n", step);
    } else {
        printf("Step %d: Light is RED - No vehicles can pass.\n", step);
    }
}

void printCurrentTrafficLight(TrafficLight light) {
    switch (light) {
        case RED:   
            printf("Current Traffic Light: RED\n");
            break;
        case GREEN: 
            printf("Current Traffic Light: GREEN\n");
            break;
        case YELLOW:
            printf("Current Traffic Light: YELLOW\n");
            break;
    }
}

int main() {
    srand(time(NULL));
    Intersection intersection = {0, RED};

    printf("Traffic Flow Simulation Started\n");

    for (int step = 0; step < NUM_STEPS; step++) {
        printCurrentTrafficLight(intersection.light);
        simulateTraffic(&intersection, step);
        updateTrafficLight(&intersection, step);
        sleep(TIME_STEP);
    }

    printf("Traffic Flow Simulation Ended\n");
    return 0;
}