//Falcon2-11B DATASET v1.0 Category: Password management ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

struct password {
    char* username;
    char* password;
    int count;
};

struct password* create_password(char* username, char* password, int count) {
    struct password* pw = malloc(sizeof(struct password));
    if (pw == NULL) {
        printf("Memory allocation failed.\n");
        return NULL;
    }
    pw->username = strdup(username);
    if (pw->username == NULL) {
        printf("Memory allocation failed.\n");
        free(pw);
        return NULL;
    }
    pw->password = strdup(password);
    if (pw->password == NULL) {
        printf("Memory allocation failed.\n");
        free(pw->username);
        free(pw);
        return NULL;
    }
    pw->count = count;
    return pw;
}

void destroy_password(struct password* pw) {
    if (pw == NULL) {
        return;
    }
    free(pw->username);
    free(pw->password);
    free(pw);
}

int main() {
    char* username = "john";
    char* password = "password";
    int count = 10;
    struct password* pw = create_password(username, password, count);
    if (pw!= NULL) {
        printf("Password created successfully.\n");
    } else {
        printf("Failed to create password.\n");
    }
    destroy_password(pw);
    return 0;
}