//Gemma-7B DATASET v1.0 Category: Medical Store Management System ; Style: real-life
#include <stdio.h>
#include <stdlib.h>

// Define the maximum number of items
#define MAX_ITEMS 100

// Define the structure of an item
typedef struct Item {
    char name[50];
    int quantity;
    double price;
} Item;

// Create an array of items
Item items[MAX_ITEMS];

// Function to add an item to the array
void addItem(char name, int quantity, double price) {
    // Iterate over the array to find an empty slot
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].quantity == 0) {
            // Copy the item information into the array
            strcpy(items[i].name, name);
            items[i].quantity = quantity;
            items[i].price = price;
            return;
        }
    }

    // If no empty slot is found, print an error message
    printf("Error: Unable to add item.\n");
}

// Function to remove an item from the array
void removeItem(char name) {
    // Iterate over the array to find the item
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            // Set the item quantity to 0
            items[i].quantity = 0;
            return;
        }
    }

    // If the item is not found, print an error message
    printf("Error: Item not found.\n");
}

// Function to update the quantity of an item
void updateQuantity(char name, int quantity) {
    // Iterate over the array to find the item
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            // Update the item quantity
            items[i].quantity = quantity;
            return;
        }
    }

    // If the item is not found, print an error message
    printf("Error: Item not found.\n");
}

// Function to calculate the total cost of an item
double calculateTotalCost(char name) {
    // Iterate over the array to find the item
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (strcmp(items[i].name, name) == 0) {
            // Return the total cost of the item
            return items[i].quantity * items[i].price;
        }
    }

    // If the item is not found, return -1
    return -1;
}

// Main function
int main() {
    // Add some items to the array
    addItem("Apple", 10, 1.20);
    addItem("Banana", 5, 0.80);
    addItem("Orange", 7, 0.90);

    // Remove an item from the array
    removeItem("Banana");

    // Update the quantity of an item
    updateQuantity("Apple", 15);

    // Calculate the total cost of an item
    double totalCost = calculateTotalCost("Orange");
    printf("Total cost of Orange: $%f\n", totalCost);

    return 0;
}