//GPT-4o-mini DATASET v1.0 Category: Pixel Art Generator ; Style: genius
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WIDTH 40
#define HEIGHT 20

#define PIXEL_CHAR '#'

void clearCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            canvas[y][x] = ' ';
        }
    }
}

void printCanvas(char canvas[HEIGHT][WIDTH]) {
    for (int y = 0; y < HEIGHT; y++) {
        for (int x = 0; x < WIDTH; x++) {
            putchar(canvas[y][x]);
        }
        putchar('\n');
    }
}

void drawPixel(char canvas[HEIGHT][WIDTH], int x, int y) {
    if (x >= 0 && x < WIDTH && y >= 0 && y < HEIGHT) {
        canvas[y][x] = PIXEL_CHAR;
    }
}

void drawLine(char canvas[HEIGHT][WIDTH], int x0, int y0, int x1, int y1) {
    int dx = abs(x1 - x0);
    int dy = abs(y1 - y0);
    int sx = (x0 < x1) ? 1 : -1; 
    int sy = (y0 < y1) ? 1 : -1; 
    int err = dx - dy;

    while (1) {
        drawPixel(canvas, x0, y0);
        if (x0 == x1 && y0 == y1) break;
        int err2 = err * 2;
        if (err2 > -dy) { err -= dy; x0 += sx; }
        if (err2 < dx) { err += dx; y0 += sy; }
    }
}

void drawRectangle(char canvas[HEIGHT][WIDTH], int x, int y, int width, int height) {
    drawLine(canvas, x, y, x + width - 1, y);
    drawLine(canvas, x, y, x, y + height - 1);
    drawLine(canvas, x + width - 1, y, x + width - 1, y + height - 1);
    drawLine(canvas, x, y + height - 1, x + width - 1, y + height - 1);
}

void drawTriangle(char canvas[HEIGHT][WIDTH], int x1, int y1, int x2, int y2, int x3, int y3) {
    drawLine(canvas, x1, y1, x2, y2);
    drawLine(canvas, x2, y2, x3, y3);
    drawLine(canvas, x3, y3, x1, y1);
}

void drawCircle(char canvas[HEIGHT][WIDTH], int xc, int yc, int r) {
    int x = r, y = 0;
    int err = 1 - r;
    while (x >= y) {
        drawPixel(canvas, xc + x, yc + y);
        drawPixel(canvas, xc + y, yc + x);
        drawPixel(canvas, xc - y, yc + x);
        drawPixel(canvas, xc - x, yc + y);
        drawPixel(canvas, xc - x, yc - y);
        drawPixel(canvas, xc - y, yc - x);
        drawPixel(canvas, xc + y, yc - x);
        drawPixel(canvas, xc + x, yc - y);
        if (err <= 0) {
            err += 2 * ++y + 1;
        } else {
            err += 2 * (y - x--) + 1;
        }
    }
}

int main() {
    char canvas[HEIGHT][WIDTH];

    clearCanvas(canvas);

    // Drawing shapes
    drawRectangle(canvas, 5, 2, 10, 5);
    drawTriangle(canvas, 15, 3, 20, 8, 25, 3);
    drawCircle(canvas, 30, 10, 4);

    printCanvas(canvas);

    // Wait for user input before closing
    printf("Press Enter to exit...");
    getchar();

    return 0;
}