//GEMINI-pro DATASET v1.0 Category: Bitwise operations ; Style: innovative
#include <stdio.h>

int main(void) {
  // Declare variables
  unsigned int a = 0x12345678;
  unsigned int b = 0x9ABCDEF0;
  unsigned int c = 0;

  // Perform bitwise AND operation
  c = a & b;
  printf("Bitwise AND: 0x%08X\n", c);

  // Perform bitwise OR operation
  c = a | b;
  printf("Bitwise OR: 0x%08X\n", c);

  // Perform bitwise XOR operation
  c = a ^ b;
  printf("Bitwise XOR: 0x%08X\n", c);

  // Perform bitwise NOT operation on a
  c = ~a;
  printf("Bitwise NOT: 0x%08X\n", c);

  // Perform bitwise left shift operation by 3 bits
  c = a << 3;
  printf("Bitwise Left Shift: 0x%08X\n", c);

  // Perform bitwise right shift operation by 3 bits
  c = a >> 3;
  printf("Bitwise Right Shift: 0x%08X\n", c);

  // Perform bitwise rotate left operation by 3 bits
  c = (a << 3) | (a >> (32 - 3));
  printf("Bitwise Rotate Left: 0x%08X\n", c);

  // Perform bitwise rotate right operation by 3 bits
  c = (a >> 3) | (a << (32 - 3));
  printf("Bitwise Rotate Right: 0x%08X\n", c);

  // Perform bitwise count set bits operation
  c = __builtin_popcount(a);
  printf("Bitwise Count Set Bits: %d\n", c);

  // Perform bitwise reverse bits operation
  c = __builtin_bswap32(a);
  printf("Bitwise Reverse Bits: 0x%08X\n", c);

  return 0;
}