//GPT-4o-mini DATASET v1.0 Category: Traffic Light Controller ; Style: statistical
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <time.h>

// Enum to represent the traffic light states
typedef enum {
    RED,
    GREEN,
    YELLOW
} TrafficLightState;

// Structure to hold the traffic light statistics
typedef struct {
    int redTime;
    int greenTime;
    int yellowTime;
    int cycleCount;
} TrafficLightStats;

// Function to simulate traffic light operation
void operateTrafficLight(TrafficLightStats *stats, int redDuration, int greenDuration, int yellowDuration, int cycles) {
    for (int i = 0; i < cycles; i++) {
        // RED Light
        printf("Cycle %d: RED Light ON for %d seconds.\n", i + 1, redDuration);
        sleep(redDuration);
        stats->redTime += redDuration;

        // GREEN Light
        printf("Cycle %d: GREEN Light ON for %d seconds.\n", i + 1, greenDuration);
        sleep(greenDuration);
        stats->greenTime += greenDuration;

        // YELLOW Light
        printf("Cycle %d: YELLOW Light ON for %d seconds.\n", i + 1, yellowDuration);
        sleep(yellowDuration);
        stats->yellowTime += yellowDuration;

        stats->cycleCount++;
    }
}

// Function to print traffic light statistics
void printTrafficLightStats(TrafficLightStats *stats) {
    printf("\n--- Traffic Light Statistics ---\n");
    printf("Total Cycles: %d\n", stats->cycleCount);
    printf("Total RED Time: %d seconds\n", stats->redTime);
    printf("Total GREEN Time: %d seconds\n", stats->greenTime);
    printf("Total YELLOW Time: %d seconds\n", stats->yellowTime);
    printf("Average RED Time per Cycle: %.2f seconds\n", (double)stats->redTime / stats->cycleCount);
    printf("Average GREEN Time per Cycle: %.2f seconds\n", (double)stats->greenTime / stats->cycleCount);
    printf("Average YELLOW Time per Cycle: %.2f seconds\n", (double)stats->yellowTime / stats->cycleCount);
}

int main() {
    TrafficLightStats stats = {0, 0, 0, 0}; // Initialize traffic light statistics
    int redDuration = 10;   // Duration for RED light
    int greenDuration = 15; // Duration for GREEN light
    int yellowDuration = 5;  // Duration for YELLOW light
    int cycleCount = 5;     // Number of cycles to simulate

    printf("Traffic Light Controller Simulation\n");
    printf("Simulating %d cycles of traffic light with durations:\n", cycleCount);
    printf("RED: %d seconds, GREEN: %d seconds, YELLOW: %d seconds\n\n", redDuration, greenDuration, yellowDuration);

    // Start operating the traffic light
    operateTrafficLight(&stats, redDuration, greenDuration, yellowDuration, cycleCount);

    // Print statistics after simulation
    printTrafficLightStats(&stats);

    return 0;
}