//GEMINI-pro DATASET v1.0 Category: Maze Route Finder ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>

#define MAZE_WIDTH 10
#define MAZE_HEIGHT 10

typedef struct {
    int x;
    int y;
} Point;

int maze[MAZE_HEIGHT][MAZE_WIDTH] = {
    {1, 1, 1, 1, 1, 1, 1, 1, 1, 1},
    {1, 0, 0, 0, 0, 0, 0, 0, 0, 1},
    {1, 0, 1, 1, 1, 1, 1, 1, 0, 1},
    {1, 0, 1, 0, 0, 0, 0, 0, 0, 1},
    {1, 0, 1, 0, 1, 1, 1, 1, 0, 1},
    {1, 0, 1, 0, 1, 0, 0, 0, 0, 1},
    {1, 0, 1, 0, 1, 0, 1, 1, 0, 1},
    {1, 0, 1, 0, 1, 0, 1, 0, 0, 1},
    {1, 0, 1, 0, 0, 0, 0, 0, 0, 1},
    {1, 1, 1, 1, 1, 1, 1, 1, 1, 1}
};

int visited[MAZE_HEIGHT][MAZE_WIDTH];

Point queue[MAZE_HEIGHT * MAZE_WIDTH];
int head = 0;
int tail = 0;

void enqueue(Point point) {
    queue[tail] = point;
    tail = (tail + 1) % (MAZE_HEIGHT * MAZE_WIDTH);
}

Point dequeue() {
    Point point = queue[head];
    head = (head + 1) % (MAZE_HEIGHT * MAZE_WIDTH);
    return point;
}

int is_valid(Point point) {
    return point.x >= 0 && point.x < MAZE_WIDTH && point.y >= 0 && point.y < MAZE_HEIGHT && !visited[point.y][point.x] && maze[point.y][point.x] == 0;
}

int main() {
    Point start = {0, 0};
    Point end = {MAZE_WIDTH - 1, MAZE_HEIGHT - 1};

    enqueue(start);
    visited[start.y][start.x] = 1;

    while (head != tail) {
        Point current = dequeue();

        if (current.x == end.x && current.y == end.y) {
            printf("Found a path!\n");
            return 0;
        }

        Point neighbors[4] = {
            {current.x, current.y - 1},
            {current.x, current.y + 1},
            {current.x - 1, current.y},
            {current.x + 1, current.y}
        };

        for (int i = 0; i < 4; i++) {
            Point neighbor = neighbors[i];
            if (is_valid(neighbor)) {
                enqueue(neighbor);
                visited[neighbor.y][neighbor.x] = 1;
            }
        }
    }

    printf("No path found.\n");
    return 1;
}