//Falcon-180B DATASET v1.0 Category: Network Topology Mapper ; Style: automated
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_NODES 100
#define MAX_EDGES 200
#define MAX_WEIGHT 1000

typedef struct {
    int id;
    char name[20];
} Node;

typedef struct {
    int source;
    int destination;
    int weight;
} Edge;

Node nodes[MAX_NODES];
Edge edges[MAX_EDGES];
int n_nodes = 0;
int n_edges = 0;

void add_node(int id, char* name) {
    if (n_nodes >= MAX_NODES) {
        printf("Error: Maximum number of nodes reached.\n");
        return;
    }

    nodes[n_nodes].id = id;
    strcpy(nodes[n_nodes].name, name);
    n_nodes++;
}

void add_edge(int source, int destination, int weight) {
    if (n_edges >= MAX_EDGES) {
        printf("Error: Maximum number of edges reached.\n");
        return;
    }

    edges[n_edges].source = source;
    edges[n_edges].destination = destination;
    edges[n_edges].weight = weight;
    n_edges++;
}

void generate_graph(int n_nodes, int n_edges) {
    printf("Generating graph...\n");

    for (int i = 0; i < n_nodes; i++) {
        printf("Node %d: %s\n", i, nodes[i].name);
    }

    for (int i = 0; i < n_edges; i++) {
        printf("Edge %d: %d -> %d (Weight: %d)\n", i, edges[i].source, edges[i].destination, edges[i].weight);
    }
}

int main() {
    add_node(0, "Node A");
    add_node(1, "Node B");
    add_node(2, "Node C");
    add_node(3, "Node D");

    add_edge(0, 1, 10);
    add_edge(1, 2, 20);
    add_edge(2, 3, 30);

    generate_graph(n_nodes, n_edges);

    return 0;
}