//Code Llama-13B DATASET v1.0 Category: TCP/IP Programming ; Style: genius
// genius_tcpip.c

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define BUF_SIZE 1024
#define PORT 8080

int main() {
    int sock;
    struct sockaddr_in server_addr;
    char buf[BUF_SIZE];

    // create a socket
    sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock == -1) {
        perror("socket");
        exit(1);
    }

    // configure server address
    memset(&server_addr, 0, sizeof(server_addr));
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = inet_addr("127.0.0.1");
    server_addr.sin_port = htons(PORT);

    // connect to the server
    if (connect(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) == -1) {
        perror("connect");
        exit(1);
    }

    // send message to the server
    send(sock, "Hello, server!", strlen("Hello, server!"), 0);

    // receive message from the server
    int bytes_received = recv(sock, buf, BUF_SIZE, 0);
    if (bytes_received == -1) {
        perror("recv");
        exit(1);
    }

    printf("Received message from server: %s\n", buf);

    // close the socket
    close(sock);

    return 0;
}