//GEMINI-pro DATASET v1.0 Category: Secure Password Generator ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <stdbool.h>
#include <string.h>
#include <time.h>

// Macros for the password character sets
#define CHARSET_LOWERCASE "abcdefghijklmnopqrstuvwxyz"
#define CHARSET_UPPERCASE "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define CHARSET_DIGITS "0123456789"
#define CHARSET_SYMBOLS "!@#$%^&*()-=_+[]{}\\|;:'\",<.>/?`"

// Function to generate a random number between two values
int generate_random_number(int min, int max) {
    return min + (rand() % (max - min + 1));
}

// Function to generate a random character from a character set
char generate_random_character(const char *charset) {
    return charset[generate_random_number(0, strlen(charset) - 1)];
}

// Function to generate a secure password of specified length
char *generate_secure_password(int length, int lowercase, int uppercase, int digits, int symbols) {
    // Check if the length is valid
    if (length < 6) {
        return NULL;
    }

    // Allocate memory for the password
    char *password = malloc(length + 1);
    if (password == NULL) {
        return NULL;
    }

    // Initialize the password to all lowercase characters
    memset(password, 'a', length);
    password[length] = '\0';

    // Generate a random character for each character set
    int i;
    for (i = 0; i < lowercase; i++) {
        password[i] = generate_random_character(CHARSET_LOWERCASE);
    }

    for (i = lowercase; i < lowercase + uppercase; i++) {
        password[i] = generate_random_character(CHARSET_UPPERCASE);
    }

    for (i = lowercase + uppercase; i < lowercase + uppercase + digits; i++) {
        password[i] = generate_random_character(CHARSET_DIGITS);
    }

    for (i = lowercase + uppercase + digits; i < length; i++) {
        password[i] = generate_random_character(CHARSET_SYMBOLS);
    }

    // Shuffle the password characters
    for (i = 0; i < length; i++) {
        int j = generate_random_number(0, length - 1);
        char temp = password[i];
        password[i] = password[j];
        password[j] = temp;
    }

    // Return the password
    return password;
}

// Main function
int main() {
    // Initialize the random number generator
    srand(time(NULL));

    // Generate a secure password
    char *password = generate_secure_password(12, 4, 4, 2, 2);

    // Print the password
    printf("Secure password: %s\n", password);

    // Free the memory allocated for the password
    free(password);

    return 0;
}