//GEMINI-pro DATASET v1.0 Category: Weather simulation ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define weather types
#define SUNNY 0
#define CLOUDY 1
#define RAINY 2
#define SNOWY 3

// Define temperature ranges
#define COLD -10
#define MILD 10
#define WARM 20
#define HOT 30

// Define humidity ranges
#define DRY 0
#define HUMID 50
#define WET 100

// Define wind speed ranges
#define CALM 0
#define BREEZY 10
#define WINDY 20
#define GUSTY 30

// Define pressure ranges
#define LOW 950
#define NORMAL 1013
#define HIGH 1050

// Create a weather simulation structure
typedef struct {
  int weatherType;
  int temperature;
  int humidity;
  int windSpeed;
  int pressure;
} Weather;

// Create a function to generate random weather
Weather generateWeather() {
  Weather weather;

  // Generate a random weather type
  weather.weatherType = rand() % 4;

  // Generate a random temperature
  weather.temperature = COLD + rand() % (HOT - COLD + 1);

  // Generate a random humidity
  weather.humidity = DRY + rand() % (WET - DRY + 1);

  // Generate a random wind speed
  weather.windSpeed = CALM + rand() % (GUSTY - CALM + 1);

  // Generate a random pressure
  weather.pressure = LOW + rand() % (HIGH - LOW + 1);

  return weather;
}

// Create a function to print the weather
void printWeather(Weather weather) {
  switch (weather.weatherType) {
    case SUNNY:
      printf("The weather is sunny.\n");
      break;
    case CLOUDY:
      printf("The weather is cloudy.\n");
      break;
    case RAINY:
      printf("The weather is rainy.\n");
      break;
    case SNOWY:
      printf("The weather is snowy.\n");
      break;
  }

  printf("The temperature is %d degrees Celsius.\n", weather.temperature);
  printf("The humidity is %d percent.\n", weather.humidity);
  printf("The wind speed is %d kilometers per hour.\n", weather.windSpeed);
  printf("The pressure is %d millibars.\n", weather.pressure);
}

// Create a main function to simulate the weather
int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Generate random weather
  Weather weather = generateWeather();

  // Print the weather
  printWeather(weather);

  return 0;
}