//Falcon-180B DATASET v1.0 Category: Typing Speed Test ; Style: intelligent
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define MAX_WORDS 10000
#define MAX_WORD_LEN 20
#define MAX_TEST_DURATION 60

struct word {
    char word[MAX_WORD_LEN];
    int length;
};

void load_words(struct word *words, int num_words) {
    FILE *fp = fopen("words.txt", "r");
    if (fp == NULL) {
        printf("Error: could not open words.txt\n");
        exit(1);
    }

    int num_loaded = 0;
    while (num_loaded < num_words && fscanf(fp, "%s", words[num_loaded].word)!= EOF) {
        words[num_loaded].length = strlen(words[num_loaded].word);
        num_loaded++;
    }

    fclose(fp);
}

int main() {
    struct word words[MAX_WORDS];
    int num_words = 0;
    load_words(words, num_words);

    srand(time(NULL));
    int test_duration = rand() % MAX_TEST_DURATION + 1;

    int num_correct = 0;
    int num_incorrect = 0;

    printf("You have %d seconds to type as many words as you can.\n", test_duration);

    for (int i = 0; i < num_words; i++) {
        printf("%s\n", words[i].word);
        char input[MAX_WORD_LEN];
        fgets(input, MAX_WORD_LEN, stdin);
        input[strcspn(input, "\n")] = '\0';

        if (strcmp(input, words[i].word) == 0) {
            num_correct++;
        } else {
            num_incorrect++;
        }
    }

    printf("Test complete. You typed %d words correctly and %d words incorrectly.\n", num_correct, num_incorrect);

    return 0;
}