//GPT-4o-mini DATASET v1.0 Category: Digital signal processing ; Style: authentic
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

// Define the number of samples
#define N 8

// Function to perform the FFT
void fft(double *real, double *imag, int n) {
    if (n <= 1) return;

    // Divide
    double evenReal[N / 2], evenImag[N / 2];
    double oddReal[N / 2], oddImag[N / 2];

    for (int i = 0; i < n / 2; i++) {
        evenReal[i] = real[i * 2];
        evenImag[i] = imag[i * 2];
        oddReal[i] = real[i * 2 + 1];
        oddImag[i] = imag[i * 2 + 1];
    }

    // Recursive calls
    fft(evenReal, evenImag, n / 2);
    fft(oddReal, oddImag, n / 2);

    // Combine
    for (int k = 0; k < n / 2; k++) {
        double tReal = cos(2 * M_PI * k / n) * oddReal[k] + sin(2 * M_PI * k / n) * oddImag[k];
        double tImag = -sin(2 * M_PI * k / n) * oddReal[k] + cos(2 * M_PI * k / n) * oddImag[k];

        real[k] = evenReal[k] + tReal;
        imag[k] = evenImag[k] + tImag;
        real[k + n / 2] = evenReal[k] - tReal;
        imag[k + n / 2] = evenImag[k] - tImag;
    }
}

// Function to calculate the magnitude spectrum
void computeMagnitude(double *real, double *imag, double *magnitude, int n) {
    for (int i = 0; i < n; i++) {
        magnitude[i] = sqrt(real[i] * real[i] + imag[i] * imag[i]);
    }
}

// Function to print arrays
void printArray(double *array, int n) {
    for (int i = 0; i < n; i++) {
        printf("%f ", array[i]);
    }
    printf("\n");
}

int main() {
    // Input Sample Signal (8 samples)
    double real[N] = {0.0, 1.0, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0};
    double imag[N] = {0.0};  // Imaginary parts are initialized to 0

    printf("Input Signal (Real Part): ");
    printArray(real, N);
    
    printf("Input Signal (Imaginary Part): ");
    printArray(imag, N);

    // Perform FFT
    fft(real, imag, N);

    // Compute Magnitude Spectrum
    double magnitude[N];
    computeMagnitude(real, imag, magnitude, N);

    // Print the results
    printf("FFT Real Part: ");
    printArray(real, N);
    
    printf("FFT Imaginary Part: ");
    printArray(imag, N);

    printf("Magnitude Spectrum: ");
    printArray(magnitude, N);

    return 0;
}