//Falcon-180B DATASET v1.0 Category: Drone Remote Control ; Style: realistic
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#define PI 3.14159265358979323846

// Drone control struct
typedef struct {
    double x;
    double y;
    double z;
    double roll;
    double pitch;
    double yaw;
} drone_t;

// Function prototypes
void drone_init(drone_t* drone);
void drone_move(drone_t* drone, double dx, double dy, double dz);
void drone_rotate(drone_t* drone, double dr, double dp, double dw);
void drone_print(drone_t* drone);

// Main function
int main() {
    drone_t drone;

    // Initialize drone position and orientation
    drone_init(&drone);

    // Move drone forward
    drone_move(&drone, 0, 0, -5);

    // Rotate drone left
    drone_rotate(&drone, 0, -PI/4, 0);

    // Print drone position and orientation
    drone_print(&drone);

    return 0;
}

// Initialize drone position and orientation
void drone_init(drone_t* drone) {
    drone->x = 0;
    drone->y = 0;
    drone->z = 0;
    drone->roll = 0;
    drone->pitch = 0;
    drone->yaw = 0;
}

// Move drone in x, y, and z directions
void drone_move(drone_t* drone, double dx, double dy, double dz) {
    drone->x += dx;
    drone->y += dy;
    drone->z += dz;
}

// Rotate drone around x, y, and z axes
void drone_rotate(drone_t* drone, double dr, double dp, double dw) {
    drone->roll += dr;
    drone->pitch += dp;
    drone->yaw += dw;
}

// Print drone position and orientation
void drone_print(drone_t* drone) {
    printf("Drone position: (%lf, %lf, %lf)\n", drone->x, drone->y, drone->z);
    printf("Drone orientation: roll = %lf, pitch = %lf, yaw = %lf\n", drone->roll, drone->pitch, drone->yaw);
}