//GPT-4o-mini DATASET v1.0 Category: Pattern printing ; Style: funny
#include <stdio.h>

// The ultimate C pattern printing program, where laughter and shapes unite!
// Grab your sneakers, folks! We're heading on a journey to pattern land!

void printSmileyFace(int size) {
    // A cheeky smiley face pattern to start us off
    for (int i = 0; i < size; i++) {
        for (int j = 0; j < size; j++) {
            if ((i == 0 && j > 0 && j < size - 1) || (i == size - 1 && j > 0 && j < size - 1)) {
                printf("-");
            } else if (j == 0 || j == size - 1) {
                printf("|");
            } else if (i == size / 2 && j == size / 2) {
                printf("O"); // A big nose
            } else if ((i == size / 4 && j == size / 4) || (i == size / 4 && j == 3 * size / 4)) {
                printf("o"); // The eyes! Are they watching you?
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

void printPyramid(int layers) {
    // What goes up must come down! Well, maybe not today.
    for (int i = 0; i < layers; i++) {
        for (int j = 0; j < layers - i - 1; j++)
            printf(" ");
        for (int j = 0; j < (2 * i + 1); j++)
            printf("*");
        printf("\n");
    }
}

void printFunnyDiamond(int n) {
    // A diamond that sparkles like your grandma's ring!
    for (int i = 0; i < n; i++) {
        for (int j = 0; j < n - i - 1; j++)
            printf(" ");
        for (int j = 0; j < (2 * i + 1); j++)
            printf("*");
        printf("\n");
    }
    for (int i = n - 2; i >= 0; i--) {
        for (int j = 0; j < n - i - 1; j++)
            printf(" ");
        for (int j = 0; j < (2 * i + 1); j++)
            printf("*");
        printf("\n");
    }
}

void printInverseTriangle(int height) {
    // A triangle flipped like pancakes on a Sunday morning!
    for (int i = height; i > 0; i--) {
        for (int j = 0; j < height - i; j++)
            printf(" ");
        for (int j = 0; j < (2 * i - 1); j++)
            printf("*");
        printf("\n");
    }
}

void printHollowSquare(int size) {
    // It’s a square, but wait, it’s also hollow? Must be magic!
    for (int i = 0; i < size; i++) {
        for (int j = 0; j < size; j++) {
            if (i == 0 || i == size - 1 || j == 0 || j == size - 1)
                printf("#");
            else
                printf(" ");
        }
        printf("\n");
    }
}

int main() {
    // Welcome to the pattern carnival! 🎪
    printf("Welcome to the C Pattern Printing Funhouse!\n\n");
    
    // 1. Smiley Face
    printf("Here's a smiley face pattern for you:\n");
    printSmileyFace(7);
    printf("\n");

    // 2. Pyramid
    printf("Now presenting the mighty pyramid of power:\n");
    printPyramid(5);
    printf("\n");

    // 3. Diamond
    printf("Brace yourself for the sparkling diamond:\n");
    printFunnyDiamond(5);
    printf("\n");

    // 4. Inverse Triangle
    printf("Behold the triangle flipped upside down!\n");
    printInverseTriangle(5);
    printf("\n");

    // 5. Hollow Square
    printf("Look! A hollow square! It's as empty as my bank account:\n");
    printHollowSquare(5);
    printf("\n");

    // Closing remarks
    printf("Thanks for enjoying this whimsical ride through patterns! 🎢\n");
    printf("Remember, coding is fun! 🕺💻\n");

    return 0;
}