//Code Llama-13B DATASET v1.0 Category: TCP/IP Programming ; Style: relaxed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#define PORT 8080
#define BUF_SIZE 1024

int main(int argc, char *argv[]) {
  int sock;
  struct sockaddr_in server_addr;
  char buffer[BUF_SIZE];
  int n;

  // create a socket
  sock = socket(AF_INET, SOCK_STREAM, 0);
  if (sock < 0) {
    perror("Error creating socket");
    exit(1);
  }

  // initialize server address
  memset(&server_addr, 0, sizeof(server_addr));
  server_addr.sin_family = AF_INET;
  server_addr.sin_addr.s_addr = INADDR_ANY;
  server_addr.sin_port = htons(PORT);

  // bind socket to address
  if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
    perror("Error binding socket");
    exit(1);
  }

  // listen for incoming connections
  if (listen(sock, 3) < 0) {
    perror("Error listening on socket");
    exit(1);
  }

  printf("Waiting for incoming connections...\n");

  // accept incoming connection
  int client_sock = accept(sock, NULL, NULL);
  if (client_sock < 0) {
    perror("Error accepting incoming connection");
    exit(1);
  }

  // read data from client
  n = read(client_sock, buffer, BUF_SIZE);
  if (n < 0) {
    perror("Error reading from client");
    exit(1);
  }

  printf("Client sent message: %s\n", buffer);

  // send response to client
  char *response = "Hello, client!";
  if (write(client_sock, response, strlen(response)) < 0) {
    perror("Error writing to client");
    exit(1);
  }

  printf("Sent response to client\n");

  // close socket
  close(client_sock);
  close(sock);

  return 0;
}