//GEMINI-pro DATASET v1.0 Category: Natural Language Date Converter ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define DAYS_IN_MONTH 31
#define DAYS_IN_WEEK 7
#define MONTHS_IN_YEAR 12

typedef struct {
    int year;
    int month;
    int day;
    int hour;
    int minute;
    int second;
} Date;

typedef struct {
    int days_since_epoch;
    int seconds_since_epoch;
} EpochTime;

EpochTime date_to_epoch_time(Date date) {
    EpochTime epoch_time;
    epoch_time.days_since_epoch = 0;
    epoch_time.seconds_since_epoch = 0;

    // Add the number of days since the beginning of the year.
    for (int i = 1; i < date.month; i++) {
        epoch_time.days_since_epoch += DAYS_IN_MONTH;
    }
    // Add the number of days since the beginning of the week.
    for (int i = 1; i < date.day; i++) {
        epoch_time.days_since_epoch += 1;
    }
    // Add the number of days since the beginning of the day.
    epoch_time.days_since_epoch += date.hour / 24;
    epoch_time.days_since_epoch += date.minute / (24 * 60);
    epoch_time.days_since_epoch += date.second / (24 * 60 * 60);

    // Add the number of seconds since the beginning of the day.
    epoch_time.seconds_since_epoch += date.second;

    return epoch_time;
}

Date epoch_time_to_date(EpochTime epoch_time) {
    Date date;
    date.year = 1970;
    date.month = 1;
    date.day = 1;
    date.hour = 0;
    date.minute = 0;
    date.second = 0;

    // Add the number of days since the beginning of the epoch.
    date.day += epoch_time.days_since_epoch;

    // Add the number of months since the beginning of the year.
    int month = 1;
    while (date.day > DAYS_IN_MONTH) {
        date.day -= DAYS_IN_MONTH;
        month++;
    }
    date.month = month;

    // Add the number of years since the beginning of the epoch.
    int year = 1970;
    while (date.month > MONTHS_IN_YEAR) {
        date.month -= MONTHS_IN_YEAR;
        year++;
    }
    date.year = year;

    // Add the number of hours since the beginning of the day.
    date.hour += epoch_time.seconds_since_epoch / 60 / 60;

    // Add the number of minutes since the beginning of the hour.
    date.minute += (epoch_time.seconds_since_epoch / 60) % 60;

    // Add the number of seconds since the beginning of the minute.
    date.second += epoch_time.seconds_since_epoch % 60;

    return date;
}

void print_date(Date date) {
    printf("%04d-%02d-%02d %02d:%02d:%02d\n", date.year, date.month, date.day, date.hour, date.minute, date.second);
}

int main() {
    // Create a date object.
    Date date;
    date.year = 2023;
    date.month = 3;
    date.day = 14;
    date.hour = 16;
    date.minute = 38;
    date.second = 59;

    // Convert the date to epoch time.
    EpochTime epoch_time = date_to_epoch_time(date);

    // Print the epoch time.
    printf("Epoch time: %d %d\n", epoch_time.days_since_epoch, epoch_time.seconds_since_epoch);

    // Convert the epoch time back to a date.
    date = epoch_time_to_date(epoch_time);

    // Print the date.
    printf("Date: ");
    print_date(date);

    return 0;
}