//MISTRAL-7B DATASET v1.0 Category: Smart home light control ; Style: synchronous
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>
#include <string.h>

#define I2C_ADDR 0x3F
#define LED_ON 0x01
#define LED_OFF 0x00

int main() {
    int fd, i;
    char buf[2];

    if ((fd = open("/dev/i2c-1", O_RDWR)) < 0) {
        perror("Failed to open i2c bus.");
        exit(1);
    }

    if (ioctl(fd, I2C_SLAVE, I2C_ADDR) < 0) {
        perror("Failed to select slave address.");
        exit(1);
    }

    for (i = 0; i < 10; i++) {
        buf[0] = LED_ON;
        if (write(fd, buf, 1) != 1) {
            perror("Failed to write to LED.");
            exit(1);
        }
        sleep(1);

        buf[0] = LED_OFF;
        if (write(fd, buf, 1) != 1) {
            perror("Failed to write to LED.");
            exit(1);
        }
        sleep(1);
    }

    if (close(fd) < 0) {
        perror("Failed to close i2c device.");
        exit(1);
    }

    return 0;
}