//Falcon-180B DATASET v1.0 Category: Digital Diary ; Style: scientific
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

struct Entry {
    time_t timestamp;
    char* content;
};

void add_entry(struct Entry* diary, int size, int capacity, char* new_entry) {
    if (size >= capacity) {
        printf("Diary is full!\n");
        return;
    }

    diary[size].timestamp = time(NULL);
    diary[size].content = new_entry;
    size++;
}

void print_diary(struct Entry* diary, int size) {
    printf("Diary:\n");
    for (int i = 0; i < size; i++) {
        printf("%s - %s\n", ctime(&diary[i].timestamp), diary[i].content);
    }
}

void delete_entry(struct Entry* diary, int size, int index) {
    if (index >= size) {
        printf("Entry not found!\n");
        return;
    }

    free(diary[index].content);
    for (int i = index; i < size - 1; i++) {
        diary[i] = diary[i + 1];
    }
    size--;
}

void search_entry(struct Entry* diary, int size, char* keyword) {
    for (int i = 0; i < size; i++) {
        if (strstr(diary[i].content, keyword)!= NULL) {
            printf("%s\n", diary[i].content);
        }
    }
}

int main() {
    struct Entry diary[100];
    int size = 0;

    srand(time(NULL));
    add_entry(diary, size, 100, "Dear diary, today I learned how to code in C!");
    add_entry(diary, size, 100, "I am excited to continue learning and improving my skills.");
    print_diary(diary, size);

    search_entry(diary, size, "learn");

    delete_entry(diary, size, 1);
    print_diary(diary, size);

    return 0;
}