//GEMINI-pro DATASET v1.0 Category: Packet Capturer with pcap library ; Style: excited
#include <pcap.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void got_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    printf("Woo-hoo! We've got a packet, baby!\n");
    printf("Packet length: %d\n", header->len);
    printf("Packet capture timestamp: %s\n", ctime((const time_t *)&header->ts.tv_sec));
    printf("Packet data:\n");
    for (int i = 0; i < header->len; i++) {
        printf("%02X ", packet[i]);
    }
    printf("\n\n");
}

int main() {
    char *device;
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    struct bpf_program fp;

    // Get the first available network device
    device = pcap_lookupdev(errbuf);
    if (device == NULL) {
        printf("Oops! Couldn't find a suitable network device. Error: %s\n", errbuf);
        exit(1);
    }

    // Open the device for packet capturing
    handle = pcap_open_live(device, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        printf("Darn it! Couldn't open the network device. Error: %s\n", errbuf);
        exit(1);
    }

    // Compile the filter expression
    if (pcap_compile(handle, &fp, "tcp port 80", 0, PCAP_NETMASK_UNKNOWN) == -1) {
        printf("Doh! Couldn't compile the filter expression.\n");
        exit(1);
    }

    // Set the filter
    if (pcap_setfilter(handle, &fp) == -1) {
        printf("Oh noes! Couldn't set the filter.\n");
        exit(1);
    }

    // Start capturing packets
    pcap_loop(handle, -1, got_packet, NULL);

    // Close the device
    pcap_close(handle);

    return 0;
}