//GEMINI-pro DATASET v1.0 Category: Sorting ; Style: satisfied
// Header files
#include <stdio.h>
#include <stdlib.h>

// Function prototypes
void swap(int *a, int *b);
void bubbleSort(int arr[], int n);
void printArray(int arr[], int n);

// Main function
int main() {
    // Initialize the array
    int arr[] = {6, 3, 1, 7, 5, 4, 9, 2, 8};
    int n = sizeof(arr) / sizeof(arr[0]);

    // Print the unsorted array
    printf("Unsorted array:\n");
    printArray(arr, n);

    // Sort the array using bubble sort
    bubbleSort(arr, n);

    // Print the sorted array
    printf("Sorted array:\n");
    printArray(arr, n);

    return 0;
}

// Function to swap two numbers
void swap(int *a, int *b) {
    int temp = *a;
    *a = *b;
    *b = temp;
}

// Function to sort the array using bubble sort
void bubbleSort(int arr[], int n) {
    for (int i = 0; i < n - 1; i++) {
        for (int j = 0; j < n - i - 1; j++) {
            if (arr[j] > arr[j + 1]) {
                swap(&arr[j], &arr[j + 1]);
            }
        }
    }
}

// Function to print the array
void printArray(int arr[], int n) {
    for (int i = 0; i < n; i++) {
        printf("%d ", arr[i]);
    }
    printf("\n");
}