//Gemma-7B DATASET v1.0 Category: Haunted House Simulator ; Style: thoughtful
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_GHOULS 5

typedef struct Ghost Ghost;
struct Ghost {
    char name[20];
    int id;
    float x, y, z;
    float speed;
    int direction;
};

Ghost ghosts[MAX_GHOULS];

void initializeGhosts() {
    for (int i = 0; i < MAX_GHOULS; i++) {
        ghosts[i].id = i + 1;
        ghosts[i].speed = 0.5f;
        ghosts[i].direction = rand() % 4;
        sprintf(ghosts[i].name, "Ghost %d", ghosts[i].id);
        ghosts[i].x = (float)rand() / (float)RAND_MAX;
        ghosts[i].y = (float)rand() / (float)RAND_MAX;
        ghosts[i].z = (float)rand() / (float)RAND_MAX;
    }
}

void moveGhosts() {
    for (int i = 0; i < MAX_GHOULS; i++) {
        switch (ghosts[i].direction) {
            case 0:
                ghosts[i].x += ghosts[i].speed;
                break;
            case 1:
                ghosts[i].y += ghosts[i].speed;
                break;
            case 2:
                ghosts[i].z += ghosts[i].speed;
                break;
            case 3:
                ghosts[i].x -= ghosts[i].speed;
                break;
        }

        if (ghosts[i].x < 0.0f || ghosts[i].x > 1.0f) {
            ghosts[i].direction = (ghosts[i].direction + 1) % 4;
        }

        if (ghosts[i].y < 0.0f || ghosts[i].y > 1.0f) {
            ghosts[i].direction = (ghosts[i].direction + 1) % 4;
        }

        if (ghosts[i].z < 0.0f || ghosts[i].z > 1.0f) {
            ghosts[i].direction = (ghosts[i].direction + 1) % 4;
        }
    }
}

int main() {
    initializeGhosts();
    moveGhosts();

    for (int i = 0; i < MAX_GHOULS; i++) {
        printf("Ghost %d: x = %.2f, y = %.2f, z = %.2f\n", ghosts[i].id, ghosts[i].x, ghosts[i].y, ghosts[i].z);
    }

    return 0;
}