//GEMINI-pro DATASET v1.0 Category: Warehouse Management System ; Style: complex
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 100
#define MAX_NAME_LENGTH 20

typedef struct {
    int id;
    char name[MAX_NAME_LENGTH];
    int quantity;
    double price;
} Item;

Item warehouse[MAX_ITEMS];
int num_items = 0;

void add_item(Item item) {
    if (num_items >= MAX_ITEMS) {
        printf("Warehouse is full!\n");
        return;
    }

    warehouse[num_items++] = item;
}

void remove_item(int id) {
    for (int i = 0; i < num_items; i++) {
        if (warehouse[i].id == id) {
            for (int j = i; j < num_items - 1; j++) {
                warehouse[j] = warehouse[j + 1];
            }
            num_items--;
            return;
        }
    }

    printf("Item not found!\n");
}

void update_item(Item item) {
    for (int i = 0; i < num_items; i++) {
        if (warehouse[i].id == item.id) {
            warehouse[i] = item;
            return;
        }
    }

    printf("Item not found!\n");
}

void print_items() {
    printf("ID\tName\tQuantity\tPrice\n");
    printf("-------------------------------------\n");
    for (int i = 0; i < num_items; i++) {
        printf("%d\t%s\t%d\t%.2f\n", warehouse[i].id, warehouse[i].name, warehouse[i].quantity, warehouse[i].price);
    }
}

int main() {
    Item item1 = {1, "Apple", 10, 1.00};
    Item item2 = {2, "Banana", 20, 1.50};
    Item item3 = {3, "Orange", 30, 2.00};

    add_item(item1);
    add_item(item2);
    add_item(item3);

    print_items();

    remove_item(2);

    print_items();

    Item item4 = {2, "Grape", 15, 1.20};

    update_item(item4);

    print_items();

    return 0;
}