//GPT-4o-mini DATASET v1.0 Category: Digital Watermarking ; Style: Sherlock Holmes
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define WIDTH 8
#define HEIGHT 8
#define WATERMARK "SHERLOCK"
#define WATERMARK_LENGTH 8

typedef struct {
    unsigned char r, g, b;
} Pixel;

void printImage(Pixel image[HEIGHT][WIDTH]) {
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            printf("(%3d,%3d,%3d) ", image[i][j].r, image[i][j].g, image[i][j].b);
        }
        printf("\n");
    }
}

void watermarkImage(Pixel image[HEIGHT][WIDTH], const char *watermark) {
    int wmIndex = 0;
    int wmBit;
    
    for (int i = 0; i < HEIGHT && wmIndex < WATERMARK_LENGTH; i++) {
        for (int j = 0; j < WIDTH && wmIndex < WATERMARK_LENGTH; j++) {
            // Get the current bit of the watermark character
            wmBit = (watermark[wmIndex / 8] >> (7 - (wmIndex % 8))) & 1;

            // Modify the least significant bit of the pixel's red component if our watermark bit is set
            if (wmBit) {
                image[i][j].r |= 1; // Set the LSB
            } else {
                image[i][j].r &= ~1; // Clear the LSB
            }
            
            wmIndex++;
        }
    }
}

void extractWatermark(Pixel image[HEIGHT][WIDTH], char *watermark) {
    memset(watermark, 0, WATERMARK_LENGTH + 1); // Reset watermark
    int wmIndex = 0;

    for (int i = 0; i < HEIGHT && wmIndex < WATERMARK_LENGTH * 8; i++) {
        for (int j = 0; j < WIDTH && wmIndex < WATERMARK_LENGTH * 8; j++) {
            // Extract the least significant bit of the pixel's red component
            watermark[wmIndex / 8] <<= 1; // Shift left
            watermark[wmIndex / 8] |= (image[i][j].r & 1); // Add LSB
            wmIndex++;
        }
    }
}

int main() {
    Pixel image[HEIGHT][WIDTH] = {0};
    
    // Create a blank image with some colors (for illustration)
    for (int i = 0; i < HEIGHT; i++) {
        for (int j = 0; j < WIDTH; j++) {
            image[i][j].r = (i * 30 + j * 20) % 256;
            image[i][j].g = (i * 40 + j * 10) % 256;
            image[i][j].b = (i * 10 + j * 50) % 256;
        }
    }

    printf("Original Image:\n");
    printImage(image);
    
    printf("\nEmbedding the watermark '%s' into the image...\n", WATERMARK);
    watermarkImage(image, WATERMARK);

    printf("\nWatermarked Image:\n");
    printImage(image);
    
    char extractedWatermark[WATERMARK_LENGTH + 1];
    extractWatermark(image, extractedWatermark);
    
    printf("\nExtracted Watermark: '%s'\n", extractedWatermark);
    
    return 0;
}