//GEMINI-pro DATASET v1.0 Category: Scientific Calculator Implementation ; Style: genius
#include <stdio.h>
#include <math.h>

typedef enum {
    OP_PLUS,
    OP_MINUS,
    OP_MULTIPLY,
    OP_DIVIDE,
    OP_POWER,
    OP_SQRT,
    OP_SIN,
    OP_COS,
    OP_TAN,
    OP_LOG,
    OP_LN,
    OP_FACTORIAL,
    OP_INVALID
} Operation;

typedef struct {
    Operation op;
    double operand;
} Expression;

double evaluate(Expression* expr) {
    switch (expr->op) {
        case OP_PLUS:
            return expr->operand + evaluate(expr + 1);
        case OP_MINUS:
            return expr->operand - evaluate(expr + 1);
        case OP_MULTIPLY:
            return expr->operand * evaluate(expr + 1);
        case OP_DIVIDE:
            return expr->operand / evaluate(expr + 1);
        case OP_POWER:
            return pow(expr->operand, evaluate(expr + 1));
        case OP_SQRT:
            return sqrt(expr->operand);
        case OP_SIN:
            return sin(expr->operand);
        case OP_COS:
            return cos(expr->operand);
        case OP_TAN:
            return tan(expr->operand);
        case OP_LOG:
            return log10(expr->operand);
        case OP_LN:
            return log(expr->operand);
        case OP_FACTORIAL:
            if (expr->operand < 0) {
                return NAN;
            }
            double result = 1;
            for (int i = 1; i <= expr->operand; i++) {
                result *= i;
            }
            return result;
        default:
            return NAN;
    }
}

int main() {
    Expression expr[] = {
        {OP_PLUS, 1},
        {OP_MULTIPLY, 2},
        {OP_MINUS, 3},
        {OP_DIVIDE, 4},
        {OP_POWER, 5},
        {OP_SQRT, 6},
        {OP_SIN, 7},
        {OP_COS, 8},
        {OP_TAN, 9},
        {OP_LOG, 10},
        {OP_LN, 11},
        {OP_FACTORIAL, 12},
        {OP_INVALID, 0}
    };
    printf("Expression:\n");
    for (int i = 0; expr[i].op != OP_INVALID; i++) {
        printf("%c%g ", expr[i].op, expr[i].operand);
    }
    printf("\nResult: %g\n", evaluate(expr));
    return 0;
}