//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

#define TRUE 1
#define FALSE 0
#define MAX_MSG_SIZE 100

typedef struct {
    long mtype;
    char mtext[MAX_MSG_SIZE];
} message_t;

int main() {
    int msgid;
    key_t key;
    message_t msg;

    // create a unique key
    key = ftok(".", 'a');

    // create a message queue
    if ((msgid = msgget(key, IPC_CREAT | 0666)) == -1) {
        printf("Error creating message queue.\n");
        exit(1);
    }

    // send a message to the message queue
    msg.mtype = 1;
    strcpy(msg.mtext, "Hello, world!");
    if (msgsnd(msgid, &msg, MAX_MSG_SIZE, 0) == -1) {
        printf("Error sending message.\n");
        exit(1);
    }

    // receive a message from the message queue
    if (msgrcv(msgid, &msg, MAX_MSG_SIZE, 1, 0) == -1) {
        printf("Error receiving message.\n");
        exit(1);
    }

    // print the received message
    printf("Received message: %s\n", msg.mtext);

    // remove the message queue
    if (msgctl(msgid, IPC_RMID, NULL) == -1) {
        printf("Error removing message queue.\n");
        exit(1);
    }

    return 0;
}