//GEMINI-pro DATASET v1.0 Category: Error handling ; Style: multivariable
#include <stdio.h>
#include <stdlib.h>

typedef struct {
  int code;
  char *message;
} Error;

#define ERR_SUCCESS 0
#define ERR_GENERAL -1
#define ERR_INVALID_ARGUMENT -2
#define ERR_NOT_FOUND -3
#define ERR_MEMORY -4
#define ERR_IO -5

static Error errors[] = {
  { ERR_SUCCESS, "Success" },
  { ERR_GENERAL, "General error" },
  { ERR_INVALID_ARGUMENT, "Invalid argument" },
  { ERR_NOT_FOUND, "Not found" },
  { ERR_MEMORY, "Memory error" },
  { ERR_IO, "I/O error" },
};

static const char *get_error_message(int code) {
  for (size_t i = 0; i < sizeof(errors) / sizeof(Error); i++) {
    if (errors[i].code == code) {
      return errors[i].message;
    }
  }
  return "Unknown error";
}

int main(void) {
  int x = 10;
  int y = 0;
  int z = 0;

  // Check for division by zero.
  if (y == 0) {
    fprintf(stderr, "Error: Division by zero.\n");
    return ERR_INVALID_ARGUMENT;
  }

  // Divide x by y.
  z = x / y;

  // Print the result.
  printf("z = %d\n", z);

  return ERR_SUCCESS;
}